
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams of calcium", lb=0)
    x2 = model.addVar(name="milligrams of vitamin A", lb=0)
    x3 = model.addVar(name="milligrams of magnesium", lb=0)
    x4 = model.addVar(name="milligrams of zinc", lb=0)

    # Define the objective function
    model.setObjective(7 * x1 + x2 + x3 + 4 * x4, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(9 * x1 <= 342, name="calcium_kidney_support")
    model.addConstr(9 * x2 <= 342, name="vitamin_A_kidney_support")
    model.addConstr(6 * x3 <= 342, name="magnesium_kidney_support")
    model.addConstr(x4 <= 342, name="zinc_kidney_support")

    model.addConstr(9 * x2 + x4 >= 53, name="vitamin_A_zinc_kidney_support")
    model.addConstr(9 * x1 + x4 >= 70, name="calcium_zinc_kidney_support")
    model.addConstr(9 * x1 + 6 * x3 + x4 >= 70, name="calcium_magnesium_zinc_kidney_support")
    model.addConstr(9 * x1 + 9 * x2 + 6 * x3 >= 70, name="calcium_vitamin_A_magnesium_kidney_support")
    model.addConstr(9 * x1 + 6 * x3 + x4 >= 84, name="calcium_magnesium_zinc_kidney_support_2")
    model.addConstr(9 * x1 + 9 * x2 + 6 * x3 >= 84, name="calcium_vitamin_A_magnesium_kidney_support_2")

    model.addConstr(9 * x1 + 9 * x2 <= 110, name="calcium_vitamin_A_kidney_support")
    model.addConstr(6 * x3 + x4 <= 236, name="magnesium_zinc_kidney_support")
    model.addConstr(9 * x2 + x4 <= 223, name="vitamin_A_zinc_kidney_support_2")
    model.addConstr(9 * x1 + 9 * x2 + 6 * x3 + x4 <= 223, name="all_kidney_support")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of calcium: {x1.varValue}")
        print(f"Milligrams of vitamin A: {x2.varValue}")
        print(f"Milligrams of magnesium: {x3.varValue}")
        print(f"Milligrams of zinc: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
