
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
fiber = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fiber")
vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")

# Set objective function
m.setObjective(8*fat + 3*magnesium + 2*fiber + 3*vitamin_b3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3.17*fat + 5.91*magnesium + 4.99*fiber + 7.55*vitamin_b3 <= 132, "c0")
m.addConstr(8.21*fat + 10.68*magnesium + 6.05*fiber + 10.32*vitamin_b3 <= 168, "c1")
m.addConstr(5.97*fat + 7.78*magnesium + 1.24*fiber + 1.56*vitamin_b3 <= 228, "c2")
m.addConstr(4.99*fiber + 7.55*vitamin_b3 >= 12, "c3")
m.addConstr(3.17*fat + 4.99*fiber >= 11, "c4")
m.addConstr(5.91*magnesium + 7.55*vitamin_b3 >= 19, "c5")
m.addConstr(3.17*fat + 7.55*vitamin_b3 >= 16, "c6")
m.addConstr(3.17*fat + 5.91*magnesium >= 26, "c7")
m.addConstr(3.17*fat + 5.91*magnesium + 7.55*vitamin_b3 >= 28, "c8")
m.addConstr(3.17*fat + 5.91*magnesium + 4.99*fiber + 7.55*vitamin_b3 >= 28, "c9")
m.addConstr(8.21*fat + 10.32*vitamin_b3 >= 25, "c10")
m.addConstr(8.21*fat + 6.05*fiber >= 24, "c11")
m.addConstr(10.68*magnesium + 10.32*vitamin_b3 >= 42, "c12")
m.addConstr(10.68*magnesium + 6.05*fiber >= 35, "c13")
m.addConstr(6.05*fiber + 10.32*vitamin_b3 >= 18, "c14")
m.addConstr(10.68*magnesium + 6.05*fiber + 10.32*vitamin_b3 >= 32, "c15")
m.addConstr(8.21*fat + 6.05*fiber + 10.32*vitamin_b3 >= 32, "c16")
m.addConstr(8.21*fat + 10.68*magnesium + 10.32*vitamin_b3 >= 32, "c17")
m.addConstr(10.68*magnesium + 6.05*fiber + 10.32*vitamin_b3 >= 33, "c18")
m.addConstr(8.21*fat + 6.05*fiber + 10.32*vitamin_b3 >= 33, "c19")
m.addConstr(8.21*fat + 10.68*magnesium + 10.32*vitamin_b3 >= 33, "c20")
m.addConstr(10.68*magnesium + 6.05*fiber + 10.32*vitamin_b3 >= 29, "c21")
m.addConstr(8.21*fat + 6.05*fiber + 10.32*vitamin_b3 >= 29, "c22")
m.addConstr(8.21*fat + 10.68*magnesium + 10.32*vitamin_b3 >= 29, "c23")
m.addConstr(8.21*fat + 10.68*magnesium + 6.05*fiber + 10.32*vitamin_b3 >= 29, "c24")
m.addConstr(5.97*fat + 1.56*vitamin_b3 >= 42, "c25")
m.addConstr(7.78*magnesium + 1.56*vitamin_b3 >= 57, "c26")
m.addConstr(5.97*fat + 7.78*magnesium >= 27, "c27")
m.addConstr(5.97*fat + 1.24*fiber + 1.56*vitamin_b3 >= 44, "c28")
m.addConstr(5.97*fat + 7.78*magnesium + 1.24*fiber >= 44, "c29")
m.addConstr(5.97*fat + 1.24*fiber + 1.56*vitamin_b3 >= 44, "c30")
m.addConstr(5.97*fat + 7.78*magnesium + 1.24*fiber >= 44, "c31")
m.addConstr(5.97*fat + 7.78*magnesium + 1.24*fiber + 1.56*vitamin_b3 >= 44, "c32")
m.addConstr(fat - 9*fiber >= 0, "c33")
m.addConstr(8.21*fat + 6.05*fiber <= 99, "c34")
m.addConstr(10.68*magnesium + 10.32*vitamin_b3 <= 76, "c35")
m.addConstr(1.24*fiber + 1.56*vitamin_b3 <= 224, "c36")
m.addConstr(7.78*magnesium + 1.24*fiber + 1.56*vitamin_b3 <= 163, "c37")
m.addConstr(5.97*fat + 7.78*magnesium + 1.56*vitamin_b3 <= 168, "c38")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Fat: %g' % fat.x)
    print('Magnesium: %g' % magnesium.x)
    print('Fiber: %g' % fiber.x)
    print('Vitamin B3: %g' % vitamin_b3.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

