
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="x1", lb=0)  # grams of fat
x2 = model.addVar(name="x2", lb=0)  # milligrams of magnesium
x3 = model.addVar(name="x3", lb=0)  # grams of fiber
x4 = model.addVar(name="x4", lb=0)  # milligrams of vitamin B3

# Define the symbolic representation of the problem
sym_variables = [('x1', 'grams of fat'), ('x2', 'milligrams of magnesium'), 
                 ('x3', 'grams of fiber'), ('x4', 'milligrams of vitamin B3')]
objective_function = '8*x1 + 3*x2 + 2*x3 + 3*x4'
constraints = [
    '3.17*x1 <= 132',
    '8.21*x1 <= 168',
    '5.97*x1 <= 228',
    '5.91*x2 <= 132',
    '10.68*x2 <= 168',
    '7.78*x2 <= 228',
    '4.99*x3 <= 132',
    '6.05*x3 <= 168',
    '1.24*x3 <= 228',
    '7.55*x4 <= 132',
    '10.32*x4 <= 168',
    '1.56*x4 <= 228',
    '4.99*x3 + 7.55*x4 >= 12',
    '3.17*x1 + 4.99*x3 >= 11',
    '5.91*x2 + 7.55*x4 >= 19',
    '3.17*x1 + 7.55*x4 >= 16',
    '3.17*x1 + 5.91*x2 >= 26',
    '3.17*x1 + 5.91*x2 + 7.55*x4 >= 28',
    '3.17*x1 + 5.91*x2 + 4.99*x3 + 7.55*x4 >= 28',
    '8.21*x1 + 10.32*x4 >= 25',
    '8.21*x1 + 6.05*x3 >= 24',
    '10.68*x2 + 10.32*x4 >= 42',
    '10.68*x2 + 6.05*x3 >= 35',
    '6.05*x3 + 10.32*x4 >= 18',
    '10.68*x2 + 6.05*x3 + 10.32*x4 >= 32',
    '8.21*x1 + 6.05*x3 + 10.32*x4 >= 32',
    '8.21*x1 + 10.68*x2 + 10.32*x4 >= 32',
    '10.68*x2 + 6.05*x3 + 10.32*x4 >= 33',
    '8.21*x1 + 6.05*x3 + 10.32*x4 >= 33',
    '8.21*x1 + 10.68*x2 + 10.32*x4 >= 33',
    '10.68*x2 + 6.05*x3 + 10.32*x4 >= 29',
    '8.21*x1 + 6.05*x3 + 10.32*x4 >= 29',
    '8.21*x1 + 10.68*x2 + 10.32*x4 >= 29',
    '8.21*x1 + 10.68*x2 + 6.05*x3 + 10.32*x4 >= 29',
    '5.97*x1 + 1.56*x4 >= 42',
    '7.78*x2 + 1.56*x4 >= 57',
    '5.97*x1 + 7.78*x2 >= 27',
    '5.97*x1 + 1.24*x3 + 1.56*x4 >= 44',
    '5.97*x1 + 7.78*x2 + 1.24*x3 >= 44',
    '5.97*x1 + 1.24*x3 + 1.56*x4 >= 44',
    '5.97*x1 + 7.78*x2 + 1.24*x3 >= 44',
    '5.97*x1 + 7.78*x2 + 1.24*x3 + 1.56*x4 >= 44',
    'x1 - 9*x3 >= 0',
    '8.21*x1 + 6.05*x3 <= 99',
    '10.68*x2 + 10.32*x4 <= 76',
    '1.24*x3 + 1.56*x4 <= 224',
    '7.78*x2 + 1.24*x3 + 1.56*x4 <= 163',
    '5.97*x1 + 7.78*x2 + 1.56*x4 <= 168'
]

# Set the objective function
model.setObjective(8 * x1 + 3 * x2 + 2 * x3 + 3 * x4, gurobi.GRB.MINIMIZE)

# Add constraints
for constraint in constraints:
    model.addConstr(eval(constraint))

# Optimize the model
model.optimize()

# Print the solution
print("Objective: ", model.objval)
print("x1: ", x1.varValue)
print("x2: ", x2.varValue)
print("x3: ", x3.varValue)
print("x4: ", x4.varValue)

# Print symbolic representation
print("Symbolic Representation:")
print("Variables: ", sym_variables)
print("Objective Function: ", objective_function)
print("Constraints: ", constraints)

