
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")  # milligrams of magnesium
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")  # milligrams of vitamin B4
    x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")  # milligrams of vitamin B5


    # Set objective function
    model.setObjective(x0**2 + 9*x0*x1 + 8*x0*x2 + 5*x1**2 + 2*x1*x2 + 4*x2**2 + 3*x0 + 2*x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(23*x0 + 10*x1 + 22*x2 >= 40, "c0")
    model.addConstr(19*x1 + 17*x2 >= 67, "c1")
    model.addConstr(18*x0**2 + 17*x2**2 >= 50, "c2")
    model.addConstr(-10*x0 + x2 >= 0, "c3")
    model.addConstr(23*x0 + 22*x2 <= 116, "c4")
    model.addConstr(10*x1**2 + 22*x2**2 <= 76, "c5")
    model.addConstr(23*x0**2 + 10*x1**2 <= 85, "c6")
    model.addConstr(23*x0 + 10*x1 + 22*x2 <= 85, "c7")
    model.addConstr(18*x0**2 + 17*x2**2 <= 111, "c8")
    model.addConstr(18*x0 + 19*x1 <= 231, "c9")
    model.addConstr(19*x1 + 17*x2 <= 154, "c10")
    model.addConstr(18*x0 + 19*x1 + 17*x2 <= 154, "c11")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
