
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="milligrams_of_magnesium", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x1 = model.addVar(name="milligrams_of_vitamin_B4", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = model.addVar(name="milligrams_of_vitamin_B5", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
model.setObjective(1*x0**2 + 9*x0*x1 + 8*x0*x2 + 5*x1**2 + 2*x1*x2 + 4*x2**2 + 3*x0 + 2*x1, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(23*x0 == 23, name="immune_support_index_magnesium")
model.addConstr(18*x0 == 18, name="digestive_support_index_magnesium")
model.addConstr(10*x1 == 10, name="immune_support_index_vitamin_B4")
model.addConstr(19*x1 == 19, name="digestive_support_index_vitamin_B4")
model.addConstr(22*x2 == 22, name="immune_support_index_vitamin_B5")
model.addConstr(17*x2 == 17, name="digestive_support_index_vitamin_B5")
model.addConstr(23*x0 + 10*x1 + 22*x2 >= 40, name="total_immune_support_index")
model.addConstr(18*x0 + 19*x1 + 17*x2 >= 67, name="total_digestive_support_index")
model.addConstr(18**2*x0**2 + 17**2*x2**2 >= 50, name="total_digestive_support_index_squared")
model.addConstr(-10*x0 + x2 >= 0, name="magnesium_vitamin_B5_constraint")
model.addConstr(23*x0 + 22*x2 <= 116, name="magnesium_vitamin_B5_immune_support")
model.addConstr(10**2*x1**2 + 22**2*x2**2 <= 76, name="vitamin_B4_vitamin_B5_immune_support_squared")
model.addConstr(23**2*x0**2 + 10**2*x1**2 <= 85, name="magnesium_vitamin_B4_immune_support_squared")
model.addConstr(23*x0 + 10*x1 + 22*x2 <= 85, name="total_immune_support_index_squared")
model.addConstr(18**2*x0**2 + 17**2*x2**2 <= 111, name="total_digestive_support_index_squared_2")
model.addConstr(18*x0 + 19*x1 <= 231, name="magnesium_vitamin_B4_digestive_support")
model.addConstr(19*x1 + 17*x2 <= 154, name="vitamin_B4_vitamin_B5_digestive_support")
model.addConstr(18*x0 + 19*x1 + 17*x2 <= 154, name="total_digestive_support_index_max")

# Optimize the model
model.optimize()

# Print the solution
print("Objective: ", model.objVal)
print("x0: ", x0.varValue)
print("x1: ", x1.varValue)
print("x2: ", x2.varValue)
