
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype='C', name="x0") # milligrams of vitamin B12
    x1 = m.addVar(lb=0, vtype='C', name="x1") # milligrams of vitamin B6
    x2 = m.addVar(lb=0, vtype='C', name="x2") # grams of carbohydrates
    x3 = m.addVar(lb=0, vtype='C', name="x3") # milligrams of zinc


    # Set objective function
    m.setObjective(3*x0 + 7*x1 + 3*x2 + 3*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13*x0 + 11*x3 >= 38)
    m.addConstr(13*x0 + 11*x1 + 11*x3 >= 37)
    m.addConstr(11*x1 + 11*x2 + 11*x3 >= 37)
    m.addConstr(13*x0 + 11*x1 + 11*x3 >= 24)
    m.addConstr(11*x1 + 11*x2 + 11*x3 >= 24)
    m.addConstr(12*x0 + 1*x1 + 4*x2 >= 24)
    m.addConstr(13*x0 + 11*x1 <= 100)
    m.addConstr(11*x2 + 11*x3 <= 87)
    m.addConstr(13*x0 + 11*x1 + 11*x2 + 11*x3 <= 87)
    m.addConstr(10*x1 + 8*x3 <= 85)
    m.addConstr(5*x0 + 8*x2 <= 33)
    m.addConstr(10*x1 + 8*x2 <= 86)
    m.addConstr(5*x0 + 8*x2 + 8*x3 <= 51)
    m.addConstr(10*x1 + 8*x2 + 8*x3 <= 87)
    m.addConstr(5*x0 + 10*x1 + 8*x3 <= 97)
    m.addConstr(5*x0 + 10*x1 + 8*x2 + 8*x3 <= 97)
    m.addConstr(4*x2 + 5*x3 <= 85)
    m.addConstr(12*x0 + 1*x1 <= 78)
    m.addConstr(1*x1 + 5*x3 <= 41)
    m.addConstr(12*x0 + 1*x1 + 5*x3 <= 39)
    m.addConstr(12*x0 + 4*x2 + 5*x3 <= 65)
    m.addConstr(12*x0 + 1*x1 + 4*x2 <= 45)
    m.addConstr(12*x0 + 1*x1 + 4*x2 + 5*x3 <= 45)

    # Resource Constraints
    m.addConstr(13*x0 + 11*x1 + 11*x2 + 11*x3 <= 172)
    m.addConstr(5*x0 + 10*x1 + 8*x2 + 8*x3 <= 115)
    m.addConstr(12*x0 + 1*x1 + 4*x2 + 5*x3 <= 105)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
