
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin B12
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B6
    x2 = model.addVar(name="x2", lb=0)  # grams of carbohydrates
    x3 = model.addVar(name="x3", lb=0)  # milligrams of zinc

    # Objective function
    model.setObjective(3*x0 + 7*x1 + 3*x2 + 3*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(13*x0 <= 172)
    model.addConstr(5*x0 <= 115)
    model.addConstr(12*x0 <= 105)
    model.addConstr(11*x1 <= 172)
    model.addConstr(10*x1 <= 115)
    model.addConstr(x1 <= 105)
    model.addConstr(11*x2 <= 172)
    model.addConstr(8*x2 <= 115)
    model.addConstr(4*x2 <= 105)
    model.addConstr(11*x3 <= 172)
    model.addConstr(8*x3 <= 115)
    model.addConstr(5*x3 <= 105)
    model.addConstr(13*x0 + 11*x3 >= 38)
    model.addConstr(13*x0 + 11*x1 + 11*x3 >= 37)
    model.addConstr(11*x1 + 11*x2 + 11*x3 >= 37)
    model.addConstr(13*x0 + 11*x1 + 11*x3 >= 24)
    model.addConstr(11*x1 + 11*x2 + 11*x3 >= 24)
    model.addConstr(12*x0 + x1 + 4*x2 >= 24)
    model.addConstr(13*x0 + 11*x1 <= 100)
    model.addConstr(11*x2 + 11*x3 <= 87)
    model.addConstr(13*x0 + 11*x1 + 11*x2 + 11*x3 <= 87)
    model.addConstr(10*x1 + 8*x3 <= 85)
    model.addConstr(5*x0 + 8*x2 <= 33)
    model.addConstr(10*x1 + 8*x2 <= 86)
    model.addConstr(5*x0 + 8*x2 + 8*x3 <= 51)
    model.addConstr(10*x1 + 8*x2 + 8*x3 <= 87)
    model.addConstr(5*x0 + 10*x1 + 8*x3 <= 97)
    model.addConstr(5*x0 + 10*x1 + 8*x2 + 8*x3 <= 97)
    model.addConstr(4*x2 + 5*x3 <= 85)
    model.addConstr(12*x0 + x1 <= 78)
    model.addConstr(x1 + 5*x3 <= 41)
    model.addConstr(12*x0 + x1 + 5*x3 <= 39)
    model.addConstr(12*x0 + 4*x2 + 5*x3 <= 65)
    model.addConstr(12*x0 + x1 + 4*x2 <= 45)
    model.addConstr(12*x0 + x1 + 4*x2 + 5*x3 <= 45)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"milligrams of vitamin B12: {x0.varValue}")
        print(f"milligrams of vitamin B6: {x1.varValue}")
        print(f"grams of carbohydrates: {x2.varValue}")
        print(f"milligrams of zinc: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
