
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b2 = m.addVar(lb=0, name="vitamin_b2")
vitamin_b9 = m.addVar(lb=0, name="vitamin_b9")
zinc = m.addVar(lb=0, name="zinc")
iron = m.addVar(lb=0, name="iron")

# Set objective function
m.setObjective(8.66 * vitamin_b2 + 4.61 * vitamin_b9 + 2.52 * zinc + 4.85 * iron, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * vitamin_b2 + 9 * zinc >= 36)
m.addConstr(3 * vitamin_b2 + 8 * vitamin_b9 + 9 * zinc + 14 * iron >= 36)
m.addConstr(10 * vitamin_b9 + 8 * iron >= 64)
m.addConstr(5 * vitamin_b2 + 13 * zinc >= 86)
m.addConstr(10 * vitamin_b9 + 13 * zinc >= 34)
m.addConstr(5 * vitamin_b2 + 10 * vitamin_b9 >= 77)
m.addConstr(5 * vitamin_b2 + 10 * vitamin_b9 + 13 * zinc >= 53)
m.addConstr(5 * vitamin_b2 + 10 * vitamin_b9 + 13 * zinc + 8 * iron >= 53)
m.addConstr(11 * vitamin_b2 + 11 * zinc >= 29)
m.addConstr(3 * vitamin_b9 + 3 * iron >= 29)
m.addConstr(11 * zinc + 3 * iron >= 32)
m.addConstr(11 * vitamin_b2 + 3 * vitamin_b9 + 11 * zinc + 3 * iron >= 32)
m.addConstr(5 * vitamin_b2 + 12 * zinc >= 66)
m.addConstr(8 * vitamin_b9 + 2 * iron >= 69)
m.addConstr(5 * vitamin_b2 + 8 * vitamin_b9 + 12 * zinc >= 56)
m.addConstr(8 * vitamin_b9 + 12 * zinc + 2 * iron >= 56)
m.addConstr(5 * vitamin_b2 + 12 * zinc + 2 * iron >= 56)
m.addConstr(5 * vitamin_b2 + 8 * vitamin_b9 + 12 * zinc >= 67)
m.addConstr(8 * vitamin_b9 + 12 * zinc + 2 * iron >= 67)
m.addConstr(5 * vitamin_b2 + 12 * zinc + 2 * iron >= 67)
m.addConstr(5 * vitamin_b2 + 8 * vitamin_b9 + 12 * zinc >= 43)
m.addConstr(8 * vitamin_b9 + 12 * zinc + 2 * iron >= 43)
m.addConstr(5 * vitamin_b2 + 12 * zinc + 2 * iron >= 43)
m.addConstr(5 * vitamin_b2 + 8 * vitamin_b9 + 12 * zinc + 2 * iron >= 43)
m.addConstr(vitamin_b9 - 3 * iron >= 0)
m.addConstr(-8 * vitamin_b2 + 9 * zinc >= 0)
m.addConstr(13 * zinc + 8 * iron <= 195)
m.addConstr(5 * vitamin_b2 + 13 * zinc + 8 * iron <= 265)
m.addConstr(8 * vitamin_b9 + 12 * zinc <= 191)
m.addConstr(12 * zinc + 2 * iron <= 311)
m.addConstr(8 * vitamin_b9 + 2 * iron <= 281)
m.addConstr(5 * vitamin_b2 + 2 * iron <= 132)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

