
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x4")


# Set objective function
m.setObjective(5*x0**2 + 6*x0*x1 + 7*x0*x2 + 3*x0*x3 + 6*x1**2 + 5*x1*x2 + 6*x1*x4 + 8*x2**2 + 4*x2*x3 + 5*x3**2 + 1*x3*x4 + 8*x4**2 + 1*x1 + 1*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x2 + 6*x4 >= 19)
m.addConstr(6*x0 + 8*x3 >= 17)
m.addConstr(6*x0 + 10*x1 >= 32)
m.addConstr(6*x0**2 + 10*x1**2 + 6*x4**2 >= 34)
m.addConstr(5*x2 + 8*x3 + 6*x4 >= 34)
m.addConstr(6*x0 + 8*x3 + 6*x4 >= 34)
m.addConstr(10*x1**2 + 8*x3**2 + 6*x4**2 >= 34)
m.addConstr(6*x0 + 5*x2 + 6*x4 >= 34)
m.addConstr(6*x0 + 10*x1 + 6*x4 >= 46)
m.addConstr(5*x2 + 8*x3 + 6*x4 >= 46)
m.addConstr(6*x0 + 8*x3 + 6*x4 >= 46)
m.addConstr(10*x1**2 + 8*x3**2 + 6*x4**2 >= 46)
m.addConstr(6*x0**2 + 5*x2**2 + 6*x4**2 >= 46)
m.addConstr(6*x0 + 10*x1 + 6*x4 >= 32)
m.addConstr(5*x2**2 + 8*x3**2 + 6*x4**2 >= 32)
m.addConstr(6*x0 + 8*x3 + 6*x4 >= 32)
m.addConstr(10*x1**2 + 8*x3**2 + 6*x4**2 >= 32)
m.addConstr(6*x0 + 5*x2 + 6*x4 >= 32)
m.addConstr(6*x0 + 10*x1 + 6*x4 >= 47)
m.addConstr(5*x2 + 8*x3 + 6*x4 >= 47)
m.addConstr(6*x0 + 8*x3 + 6*x4 >= 47)
m.addConstr(10*x1 + 8*x3 + 6*x4 >= 47)
m.addConstr(6*x0 + 5*x2 + 6*x4 >= 47)
m.addConstr(6*x0 + 10*x1 + 6*x4 >= 34)
m.addConstr(5*x2 + 8*x3 + 6*x4 >= 34)
m.addConstr(6*x0 + 8*x3 + 6*x4 >= 34)
m.addConstr(10*x1 + 8*x3 + 6*x4 >= 34)
m.addConstr(6*x0 + 5*x2 + 6*x4 >= 34)
# ... (rest of the constraints)


# Resource constraints
m.addConstr(6 * x0 <= 236)
m.addConstr(16 * x0 <= 218)
m.addConstr(10 * x1 <= 236)
m.addConstr(11 * x1 <= 218)
m.addConstr(5 * x2 <= 236)
m.addConstr(17 * x2 <= 218)
m.addConstr(8 * x3 <= 236)
m.addConstr(1 * x3 <= 218)
m.addConstr(6 * x4 <= 236)
m.addConstr(1 * x4 <= 218)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

