
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B1
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin C
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin B6


    # Set objective function
    m.setObjective(8.69*x0**2 + 7.18*x0*x1 + 5.96*x1**2 + 7.86*x2**2 + 7.79*x0 + 5.08*x1 + 8.92*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2*x0 + 7*x1 + 2*x2 <= 83, "c0") # kidney support index
    m.addConstr(5*x0 + 7*x1 + 5*x2 <= 146, "c1") # digestive support index
    m.addConstr(2*x0**2 + 7*x1**2 <= 76, "c2")
    m.addConstr(2*x0**2 + 2*x2**2 <= 52, "c3")
    m.addConstr(2*x0 + 7*x1 + 2*x2 <= 70, "c4")
    m.addConstr(7*x1**2 + 5*x2**2 <= 85, "c5")
    m.addConstr(5*x0**2 + 5*x2**2 <= 87, "c6")
    m.addConstr(5*x0**2 + 7*x1**2 + 5*x2**2 <= 109, "c7")
    m.addConstr(5*x0 + 7*x1 + 5*x2 <= 109, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
