
import gurobi

def optimize_vitamins():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # milligrams of vitamin B1
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")  # milligrams of vitamin C
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin B6

    # Objective function
    model.setObjective(8.69*x1**2 + 7.18*x1*x2 + 5.96*x2**2 + 7.86*x3**2 + 7.79*x1 + 5.08*x2 + 8.92*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 + 7*x2 + 2*x3 <= 83, name="kidney_support")
    model.addConstr(5*x1 + 7*x2 + 5*x3 <= 146, name="digestive_support")
    model.addConstr(x1**2 + x2**2 <= 76, name="kidney_support_B1_B2")
    model.addConstr(x1**2 + x3**2 <= 52, name="kidney_support_B1_B6")
    model.addConstr(x1 + x2 + x3 <= 70, name="total_kidney_support")
    model.addConstr(x2**2 + x3**2 <= 85, name="digestive_support_B2_B6")
    model.addConstr(x1**2 + x3**2 <= 87, name="digestive_support_B1_B6_2")
    model.addConstr(x1**2 + x2**2 + x3**2 <= 109, name="total_digestive_support")
    model.addConstr(x1 + x2 + x3 <= 109, name="total_digestive_support_2")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B1: {x1.varValue}")
        print(f"Milligrams of vitamin C: {x2.varValue}")
        print(f"Milligrams of vitamin B6: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
