
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="water_purification_units")
    x1 = model.addVar(vtype=GRB.INTEGER, name="artillery_batteries")


    # Set objective function
    model.setObjective(6.99 * x0 * x1 + 1.76 * x1, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1.42 * x0 + 2.18 * x1 >= 45, "logistical_capacity_lower_bound")
    model.addConstr(1.07 * x0 + 2.72 * x1 >= 48, "fun_factor_lower_bound")
    model.addConstr(-5 * x0 * x0 + 1 * x1 * x1 >= 0, "quadratic_constraint")
    model.addConstr(1.42 * x0 + 2.18 * x1 <= 95, "logistical_capacity_upper_bound")
    model.addConstr((1.07 * x0) * (1.07*x0) + (2.72 * x1) * (2.72*x1) <= 54, "fun_factor_upper_bound")
    model.addConstr(x0*x0 + x1*x1 >= 45, "logistical_capacity_squared_lower_bound")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        print(f"Water purification units: {x0.x}")
        print(f"Artillery batteries: {x1.x}")
        print(f"Objective value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")
