
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="water_purification_units", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="artillery_batteries", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(6.99 * x1 * x2 + 1.76 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(1.42 * x1 + 2.18 * x2 >= 45)
    model.addConstr(1.07 * x1 + 2.72 * x2 >= 48)
    model.addConstr((1.42 * x1)**2 + (2.18 * x2)**2 >= 45)
    model.addConstr((1.07 * x1)**2 + (2.72 * x2)**2 <= 54)
    model.addConstr(-5 * x1**2 + x2**2 >= 0)
    model.addConstr(1.42 * x1 + 2.18 * x2 <= 95)

    # Set the bounds for logistical capacity and fun factor
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Water purification units: {x1.varValue}")
        print(f"Artillery batteries: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
