
import gurobipy as gp

# Create a new model
model = gp.Model("office_supplies")

# Create variables
blue_pens = model.addVar(vtype=gp.GRB.INTEGER, name="blue_pens")
packs_of_paper = model.addVar(vtype=gp.GRB.INTEGER, name="packs_of_paper")
usb_flash_drives = model.addVar(vtype=gp.GRB.INTEGER, name="usb_flash_drives")
staplers = model.addVar(vtype=gp.GRB.INTEGER, name="staplers")


# Set objective function
model.setObjective(9.32 * blue_pens + 6.84 * packs_of_paper + 7.13 * usb_flash_drives + 9.44 * staplers, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(16 * blue_pens + 16 * usb_flash_drives >= 55, "c1")
model.addConstr(16 * usb_flash_drives + 15 * staplers >= 128, "c2")
model.addConstr(11 * packs_of_paper + 16 * usb_flash_drives >= 97, "c3")
model.addConstr(16 * blue_pens + 16 * usb_flash_drives + 15 * staplers >= 125, "c4")
model.addConstr(11 * packs_of_paper + 16 * usb_flash_drives + 15 * staplers >= 125, "c5")
model.addConstr(16 * blue_pens + 11 * packs_of_paper + 15 * staplers >= 125, "c6")
model.addConstr(16 * blue_pens + 11 * packs_of_paper + 16 * usb_flash_drives >= 125, "c7")

model.addConstr(16 * blue_pens + 16 * usb_flash_drives + 15 * staplers >= 85, "c8")
model.addConstr(11 * packs_of_paper + 16 * usb_flash_drives + 15 * staplers >= 85, "c9")
model.addConstr(16 * blue_pens + 11 * packs_of_paper + 15 * staplers >= 85, "c10")
model.addConstr(16 * blue_pens + 11 * packs_of_paper + 16 * usb_flash_drives >= 85, "c11")

model.addConstr(16 * blue_pens + 16 * usb_flash_drives + 15 * staplers >= 119, "c12")
model.addConstr(11 * packs_of_paper + 16 * usb_flash_drives + 15 * staplers >= 119, "c13")
model.addConstr(16 * blue_pens + 11 * packs_of_paper + 15 * staplers >= 119, "c14")
model.addConstr(16 * blue_pens + 11 * packs_of_paper + 16 * usb_flash_drives >= 119, "c15")

model.addConstr(16 * blue_pens + 16 * usb_flash_drives + 15 * staplers >= 103, "c16")
model.addConstr(11 * packs_of_paper + 16 * usb_flash_drives + 15 * staplers >= 103, "c17")
model.addConstr(16 * blue_pens + 11 * packs_of_paper + 15 * staplers >= 103, "c18")
model.addConstr(16 * blue_pens + 11 * packs_of_paper + 16 * usb_flash_drives >= 103, "c19")
model.addConstr(16 * blue_pens + 11 * packs_of_paper + 16 * usb_flash_drives + 15 * staplers >= 103, "c20")


model.addConstr(-6 * packs_of_paper + 4 * usb_flash_drives >= 0, "c21")
model.addConstr(-1 * packs_of_paper + 4 * staplers >= 0, "c22")
model.addConstr(16 * blue_pens + 16 * usb_flash_drives + 15 * staplers <= 511, "c23")
model.addConstr(16 * blue_pens + 11 * packs_of_paper + 15 * staplers <= 399, "c24")
model.addConstr(11 * packs_of_paper + 16 * usb_flash_drives + 15 * staplers <= 397, "c25")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Blue pens: {blue_pens.x}")
    print(f"Packs of paper: {packs_of_paper.x}")
    print(f"USB flash drives: {usb_flash_drives.x}")
    print(f"Staplers: {staplers.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

