
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='blue_pens', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='packs_of_paper', vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name='usb_flash_drives', vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name='staplers', vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(9.32*x1 + 6.84*x2 + 7.13*x3 + 9.44*x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(16*x1 + 16*x3 >= 55)
m.addConstr(16*x3 + 15*x4 >= 128)
m.addConstr(11*x2 + 16*x3 >= 97)
m.addConstr(16*x1 + 16*x3 + 15*x4 >= 125)
m.addConstr(11*x2 + 16*x3 + 15*x4 >= 125)
m.addConstr(16*x1 + 11*x2 + 15*x4 >= 125)
m.addConstr(16*x1 + 11*x2 + 16*x3 >= 125)
m.addConstr(16*x1 + 16*x3 + 15*x4 >= 85)
m.addConstr(11*x2 + 16*x3 + 15*x4 >= 85)
m.addConstr(16*x1 + 11*x2 + 15*x4 >= 85)
m.addConstr(16*x1 + 11*x2 + 16*x3 >= 85)
m.addConstr(16*x1 + 16*x3 + 15*x4 >= 119)
m.addConstr(11*x2 + 16*x3 + 15*x4 >= 119)
m.addConstr(16*x1 + 11*x2 + 15*x4 >= 119)
m.addConstr(16*x1 + 11*x2 + 16*x3 >= 119)
m.addConstr(16*x1 + 16*x3 + 15*x4 >= 103)
m.addConstr(11*x2 + 16*x3 + 15*x4 >= 103)
m.addConstr(16*x1 + 11*x2 + 15*x4 >= 103)
m.addConstr(16*x1 + 11*x2 + 16*x3 >= 103)
m.addConstr(16*x1 + 11*x2 + 16*x3 + 15*x4 >= 103)
m.addConstr(-6*x2 + 4*x3 >= 0)
m.addConstr(-x2 + 4*x4 >= 0)
m.addConstr(16*x1 + 16*x3 + 15*x4 <= 511)
m.addConstr(16*x1 + 11*x2 + 15*x4 <= 399)
m.addConstr(11*x2 + 16*x3 + 15*x4 <= 397)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objval)
    print('blue pens: ', x1.varValue)
    print('packs of paper: ', x2.varValue)
    print('usb flash drives: ', x3.varValue)
    print('staplers: ', x4.varValue)
else:
    print('No solution found')
