
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B5
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1")  # milligrams of magnesium
    x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2")  # milligrams of vitamin B1
    x3 = m.addVar(vtype=GRB.CONTINUOUS, name="x3")  # milligrams of vitamin E


    # Set objective function
    m.setObjective(8.94*x0**2 + 6.08*x0*x1 + 5.33*x1**2 + 3.3*x0, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(10*x0 + 8*x1 + 1*x2 + 14*x3 <= 103, "c0")
    m.addConstr(10*x0 + 8*x1 + 1*x2 >= 15, "c1")
    m.addConstr(1*x2**2 + 14*x3**2 <= 29, "c2")
    m.addConstr(10*x0 + 8*x1 <= 88, "c3")
    m.addConstr(8*x1 + 1*x2 <= 40, "c4")
    m.addConstr(8*x1 + 14*x3 <= 89, "c5")
    m.addConstr(8*x1**2 + 1*x2**2 + 14*x3**2 <= 79, "c6")
    m.addConstr(10*x0 + 8*x1 + 14*x3 <= 89, "c7")
    m.addConstr(10*x0 + 8*x1 + 1*x2 + 14*x3 <= 89, "c8")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
