
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B5
x2 = model.addVar(name="x2", lb=0)  # milligrams of magnesium
x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin B1
x4 = model.addVar(name="x4", lb=0)  # milligrams of vitamin E

# Objective function
model.setObjective(8.94*x1**2 + 6.08*x1*x2 + 5.33*x2**2 + 3.3*x1, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(10*x1 + 8*x2 + x3 >= 15)
model.addConstr(x3**2 + x4**2 <= 29)
model.addConstr(10*x1 + 8*x2 <= 88)
model.addConstr(8*x2 + x3 <= 40)
model.addConstr(8*x2 + 14*x4 <= 89)
model.addConstr(64*x2**2 + x3**2 + 196*x4**2 <= 79)
model.addConstr(10*x1 + 8*x2 + 14*x4 <= 89)
model.addConstr(10*x1 + 8*x2 + x3 + 14*x4 <= 89)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("x1:", x1.varValue)
    print("x2:", x2.varValue)
    print("x3:", x3.varValue)
    print("x4:", x4.varValue)
    print("Objective:", model.objVal)
else:
    print("No optimal solution found.")
