
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B3
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # grams of carbohydrates
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of iron


    # Set objective function
    m.setObjective(4.93 * x0 + 9.47 * x1 + 2.7 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(19 * x0 + 8 * x1 + 12 * x2 <= 141, "c0")
    m.addConstr(8 * x0 + 17 * x1 + 11 * x2 <= 139, "c1")
    m.addConstr(15 * x0 + 17 * x1 + 22 * x2 <= 65, "c2")
    m.addConstr(8 * x1 + 12 * x2 >= 21, "c3")
    m.addConstr(19 * x0 + 12 * x2 >= 40, "c4")
    m.addConstr(19 * x0 + 8 * x1 + 12 * x2 >= 40, "c5")
    m.addConstr(8 * x0 + 11 * x2 >= 25, "c6")
    m.addConstr(17 * x1 + 11 * x2 >= 26, "c7")
    m.addConstr(8 * x0 + 17 * x1 + 11 * x2 >= 45, "c8")
    m.addConstr(17 * x1 + 22 * x2 >= 15, "c9")
    m.addConstr(15 * x0 + 22 * x2 >= 7, "c10")
    m.addConstr(15 * x0 + 17 * x1 >= 21, "c11")
    m.addConstr(15 * x0 + 17 * x1 + 22 * x2 >= 21, "c12")
    m.addConstr(x0 - 7 * x1 >= 0, "c13")
    m.addConstr(-7 * x1 + 3 * x2 >= 0, "c14")
    m.addConstr(8 * x0 + 17 * x1 + 11 * x2 <= 109, "c15")
    m.addConstr(15 * x0 + 22 * x2 <= 63, "c16")
    m.addConstr(15 * x0 + 17 * x1 <= 64, "c17")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
