
import gurobi

def optimize():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="milligrams_of_vitamin_B3", lb=0)
    x2 = model.addVar(name="grams_of_carbohydrates", lb=0)
    x3 = model.addVar(name="milligrams_of_iron", lb=0)

    # Objective function
    model.setObjective(4.93*x1 + 9.47*x2 + 2.7*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8*x1 + 17*x2 + 11*x3 >= 45)
    model.addConstr(19*x1 + 8*x2 + 12*x3 >= 40)
    model.addConstr(15*x1 + 17*x2 >= 21)
    model.addConstr(15*x1 + 22*x3 >= 7)
    model.addConstr(x1 - 7*x2 >= 0)
    model.addConstr(-7*x2 + 3*x3 >= 0)
    model.addConstr(8*x1 + 17*x2 + 11*x3 <= 109)
    model.addConstr(15*x1 + 22*x3 <= 63)
    model.addConstr(15*x1 + 17*x2 <= 64)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Milligrams of vitamin B3: ", x1.varValue)
        print("Grams of carbohydrates: ", x2.varValue)
        print("Milligrams of iron: ", x3.varValue)
    else:
        print("No optimal solution found")

optimize()
