
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("muscle_growth")

    # Create variables
    x = m.addVars(5, lb=0, names=["B4", "Zinc", "Iron", "Calcium", "Magnesium"])
    x[0].vtype = gp.GRB.INTEGER  # B4 must be an integer


    # Set objective function
    m.setObjective(9*x[0] + 6*x[1] + 3*x[2] + 2*x[3] + x[4], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(11*x[0] + 4*x[1] >= 30)
    m.addConstr(4*x[1] + 13*x[2] >= 29)
    m.addConstr(11*x[0] + 2*x[3] >= 24)
    m.addConstr(13*x[2] + 2*x[3] >= 24)
    m.addConstr(4*x[1] + 9*x[4] >= 30)
    m.addConstr(4*x[1] + 2*x[3] >= 27)
    m.addConstr(4*x[1] + 13*x[2] <= 184)
    m.addConstr(4*x[1] + 2*x[3] <= 62)
    m.addConstr(13*x[2] + 9*x[4] <= 146)
    m.addConstr(11*x[0] + 4*x[1] <= 55)
    m.addConstr(11*x[0] + 13*x[2] + 2*x[3] <= 174)
    m.addConstr(11*x[0] + 4*x[1] + 13*x[2] <= 162)
    m.addConstr(11*x[0] + 2*x[3] + 9*x[4] <= 59)
    m.addConstr(11*x[0] + 4*x[1] + 13*x[2] + 2*x[3] + 9*x[4] <= 59)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GrorbiError as e:
    print(f'Error code {e.errno}: {e.message}')

except AttributeError:
    print('Encountered an attribute error')
