
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='x1', vtype='I') # integer
x2 = m.addVar(name='x2') 
x3 = m.addVar(name='x3') 
x4 = m.addVar(name='x4') 
x5 = m.addVar(name='x5') 

# Objective function
m.setObjective(9*x1 + 6*x2 + 3*x3 + 2*x4 + x5, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(11*x1 + 4*x2 >= 30)
m.addConstr(4*x2 + 13*x3 >= 29)
m.addConstr(11*x1 + 2*x4 >= 24)
m.addConstr(13*x3 + 2*x4 >= 24)
m.addConstr(4*x2 + 9*x5 >= 30)
m.addConstr(4*x2 + 2*x4 >= 27)
m.addConstr(4*x2 + 13*x3 <= 184)
m.addConstr(4*x2 + 2*x4 <= 62)
m.addConstr(13*x3 + 9*x5 <= 146)
m.addConstr(11*x1 + 4*x2 <= 55)
m.addConstr(11*x1 + 13*x3 + 2*x4 <= 174)
m.addConstr(11*x1 + 4*x2 + 13*x3 <= 162)
m.addConstr(11*x1 + 2*x4 + 9*x5 <= 59)
m.addConstr(11*x1 + 4*x2 + 13*x3 + 2*x4 + 9*x5 <= 59)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
    print('x4: ', x4.varValue)
    print('x5: ', x5.varValue)
else:
    print('No solution found')
