
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
mary = model.addVar(vtype=gp.GRB.INTEGER, name="mary")
bobby = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bobby")
bill = model.addVar(vtype=gp.GRB.INTEGER, name="bill")
laura = model.addVar(vtype=gp.GRB.INTEGER, name="laura")


# Set objective function
model.setObjective(3.06*mary**2 + 1.58*mary*bill + 5.27*bobby*bill + 5.19*bobby*laura + 4.9*bill**2 + 6.23*bill*laura + 2.23*bobby + 2.24*bill, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*bobby + 20*laura >= 36)
model.addConstr(1*bill + 20*laura >= 27)
model.addConstr(20*mary + 19*bobby >= 48)
model.addConstr(20*mary**2 + 20*laura**2 >= 37)
model.addConstr(19*bobby + 1*bill >= 26)
model.addConstr(20*mary + 1*bill + 20*laura >= 35)
model.addConstr(19*bobby + 1*bill + 20*laura >= 35)
model.addConstr(20*mary**2 + 19*bobby**2 + 20*laura**2 >= 35)
model.addConstr(20*mary + 19*bobby + 1*bill >= 35)
model.addConstr(20*mary + 1*bill + 20*laura >= 39)
model.addConstr(19*bobby + 1*bill + 20*laura >= 39)
model.addConstr(20*mary + 19*bobby + 20*laura >= 39)
model.addConstr(20*mary + 19*bobby + 1*bill >= 39)
model.addConstr(20*mary + 1*bill + 20*laura >= 53)
model.addConstr(19*bobby + 1*bill + 20*laura >= 53)
model.addConstr(20*mary + 19*bobby + 20*laura >= 53)
model.addConstr(20*mary + 19*bobby + 1*bill >= 53)
model.addConstr(20*mary**2 + 1*bill**2 + 20*laura**2 >= 54)
model.addConstr(19*bobby + 1*bill + 20*laura >= 54)
model.addConstr(20*mary**2 + 19*bobby**2 + 20*laura**2 >= 54)
model.addConstr(20*mary + 19*bobby + 1*bill >= 54)
model.addConstr(7*bobby - 7*bill - 7*laura >= 0)
model.addConstr(20*mary**2 + 20*laura**2 <= 162)
model.addConstr(1*bill**2 + 20*laura**2 <= 84)
model.addConstr(19*bobby + 20*laura <= 196)
model.addConstr(20*mary**2 + 1*bill**2 <= 125)
model.addConstr(20*mary + 19*bobby + 1*bill <= 106)
model.addConstr(20*mary + 1*bill + 20*laura <= 180)
model.addConstr(20*mary + 19*bobby + 1*bill + 20*laura <= 180)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

