
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # hours worked by Mary
    x2 = model.addVar(name='x2', vtype=gurobi.GRB.CONTINUOUS)  # hours worked by Bobby
    x3 = model.addVar(name='x3', vtype=gurobi.GRB.INTEGER)  # hours worked by Bill
    x4 = model.addVar(name='x4', vtype=gurobi.GRB.INTEGER)  # hours worked by Laura

    # Objective function
    model.setObjective(3.06*x1**2 + 1.58*x1*x3 + 5.27*x2*x3 + 5.19*x2*x4 + 4.9*x3**2 + 6.23*x3*x4 + 2.23*x2 + 2.24*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20*x1 <= 236)
    model.addConstr(19*x2 <= 236)
    model.addConstr(x3 <= 236)
    model.addConstr(20*x4 <= 236)
    model.addConstr(19*x2 + 20*x4 >= 36)
    model.addConstr(x3 + 20*x4 >= 27)
    model.addConstr(20*x1 + 19*x2 >= 48)
    model.addConstr(400*x1**2 + 400*x4**2 >= 37)
    model.addConstr(19*x2 + x3 >= 26)
    model.addConstr(20*x1 + x3 + 20*x4 >= 35)
    model.addConstr(19*x2 + x3 + 20*x4 >= 35)
    model.addConstr(400*x1**2 + 361*x2**2 + 400*x4**2 >= 35)
    model.addConstr(20*x1 + 19*x2 + x3 >= 35)
    model.addConstr(20*x1 + x3 + 20*x4 >= 39)
    model.addConstr(19*x2 + x3 + 20*x4 >= 39)
    model.addConstr(20*x1 + 19*x2 + 20*x4 >= 39)
    model.addConstr(20*x1 + 19*x2 + x3 >= 39)
    model.addConstr(20*x1 + x3 + 20*x4 >= 53)
    model.addConstr(19*x2 + x3 + 20*x4 >= 53)
    model.addConstr(20*x1 + 19*x2 + 20*x4 >= 53)
    model.addConstr(20*x1 + 19*x2 + x3 >= 53)
    model.addConstr(400*x1**2 + x3**2 + 400*x4**2 >= 54)
    model.addConstr(19*x2 + x3 + 20*x4 >= 54)
    model.addConstr(400*x1**2 + 361*x2**2 + 400*x4**2 >= 54)
    model.addConstr(20*x1 + 19*x2 + x3 >= 54)
    model.addConstr(7*x2 - 7*x3 - 7*x4 >= 0)
    model.addConstr(400*x1**2 + 400*x4**2 <= 162)
    model.addConstr(x3**2 + 400*x4**2 <= 84)
    model.addConstr(19*x2 * 20*x4 <= 196)
    model.addConstr(400*x1**2 + x3**2 <= 125)
    model.addConstr(20*x1 + 19*x2 + x3 <= 106)
    model.addConstr(20*x1 + x3 + 20*x4 <= 180)
    model.addConstr(20*x1 + 19*x2 + x3 + 20*x4 <= 180)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
        print('x3: ', x3.varValue)
        print('x4: ', x4.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
