
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x = m.addVars(7, lb=0, vtype=[gp.GRB.CONTINUOUS, gp.GRB.INTEGER, gp.GRB.CONTINUOUS, gp.GRB.INTEGER, gp.GRB.INTEGER, gp.GRB.INTEGER, gp.GRB.CONTINUOUS], name=["x0", "x1", "x2", "x3", "x4", "x5", "x6"])


# Set objective function
m.setObjective(8.36 * x[0] + 2.99 * x[1] + 8.31 * x[2] + 5.45 * x[3] + 7.24 * x[4] + 2.63 * x[5] + 3.48 * x[6], gp.GRB.MAXIMIZE)

# Resource coefficients
r = {
    'r0': [2.32, 6.91, 2.95, 6.46, 2.25, 4.11, 5.86],  # energy stability index
    'r1': [0.22, 3.87, 2.62, 5.32, 3.89, 6.9, 2.74],  # immune support index
    'r2': [4.48, 1.77, 5.33, 4.79, 5.46, 4.41, 1.14]   # muscle growth index
}

# Resource upper bounds
resource_bounds = {
    'r0': 578,
    'r1': 231,
    'r2': 201
}

# Add resource constraints
m.addConstr(gp.quicksum(r['r0'][i] * x[i] for i in range(7)) <= resource_bounds['r0'], "r0_ub")
m.addConstr(gp.quicksum(r['r1'][i] * x[i] for i in range(7)) <= resource_bounds['r1'], "r1_ub")
m.addConstr(gp.quicksum(r['r2'][i] * x[i] for i in range(7)) <= resource_bounds['r2'], "r2_ub")


# Add other constraints from the problem description (truncated for brevity - add all constraints from JSON)
m.addConstr(r['r0'][0] * x[0] + r['r0'][1] * x[1] >= 77)
m.addConstr(r['r0'][0] * x[0] + r['r0'][6] * x[6] >= 77)
# ... (add all remaining constraints)


# Optimize model
m.optimize()

# Print solution or infeasibility status
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
    print('Obj: %g' % m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

