
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
dale_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale_hours")
paul_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul_hours")
laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Laura_hours")
john_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="John_hours")


# Set objective function
m.setObjective(9.78 * dale_hours + 3.35 * paul_hours + 4.5 * laura_hours + 4.6 * john_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * dale_hours + 12 * laura_hours >= 65)
m.addConstr(9 * dale_hours + 9 * john_hours >= 40)
m.addConstr(9 * dale_hours + 9 * paul_hours >= 44)
m.addConstr(9 * paul_hours + 9 * john_hours >= 65)
m.addConstr(9 * paul_hours + 12 * laura_hours >= 34)
m.addConstr(9 * dale_hours + 9 * paul_hours + 12 * laura_hours >= 55)
m.addConstr(9 * dale_hours + 12 * laura_hours + 9 * john_hours >= 55)
m.addConstr(9 * paul_hours + 12 * laura_hours + 9 * john_hours >= 55)
m.addConstr(9 * dale_hours + 9 * paul_hours + 12 * laura_hours >= 63)
m.addConstr(9 * dale_hours + 12 * laura_hours + 9 * john_hours >= 63)
m.addConstr(9 * paul_hours + 12 * laura_hours + 9 * john_hours >= 63)
m.addConstr(9 * dale_hours + 9 * paul_hours + 12 * laura_hours >= 44)
m.addConstr(9 * dale_hours + 12 * laura_hours + 9 * john_hours >= 44)
m.addConstr(9 * paul_hours + 12 * laura_hours + 9 * john_hours >= 44)
m.addConstr(9 * dale_hours + 9 * paul_hours + 12 * laura_hours + 9 * john_hours >= 44)
m.addConstr(9 * dale_hours + 10 * laura_hours >= 68)
m.addConstr(11 * paul_hours + 11 * john_hours >= 66)
m.addConstr(9 * dale_hours + 11 * paul_hours >= 76)
m.addConstr(9 * dale_hours + 10 * laura_hours + 11 * john_hours >= 76)
m.addConstr(9 * dale_hours + 11 * paul_hours + 10 * laura_hours + 11 * john_hours >= 76)
m.addConstr(6 * paul_hours + 2 * laura_hours >= 13)
m.addConstr(2 * laura_hours + 11 * john_hours >= 13)
m.addConstr(11 * dale_hours + 2 * laura_hours >= 18)
m.addConstr(11 * dale_hours + 6 * paul_hours + 2 * laura_hours + 11 * john_hours >= 18)
m.addConstr(-10 * laura_hours + 3 * john_hours >= 0)
m.addConstr(9 * paul_hours + 9 * john_hours <= 169)
m.addConstr(9 * dale_hours + 12 * laura_hours <= 178)
m.addConstr(9 * dale_hours + 9 * paul_hours <= 228)
m.addConstr(9 * paul_hours + 12 * laura_hours + 9 * john_hours <= 91)
m.addConstr(9 * dale_hours + 11 * paul_hours + 11 * john_hours <= 86)
m.addConstr(6 * paul_hours + 2 * laura_hours + 11 * john_hours <= 26)
m.addConstr(11 * dale_hours + 2 * laura_hours + 11 * john_hours <= 62)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

