
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Dale
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Paul
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Laura
    x3 = model.addVar(name="x3", lb=0)  # hours worked by John

    # Objective function
    model.setObjective(9.78 * x0 + 3.35 * x1 + 4.5 * x2 + 4.6 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9 * x0 <= 262)
    model.addConstr(9 * x1 <= 262)
    model.addConstr(12 * x2 <= 262)
    model.addConstr(9 * x3 <= 262)
    model.addConstr(9 * x0 <= 320)
    model.addConstr(11 * x1 <= 320)
    model.addConstr(10 * x2 <= 320)
    model.addConstr(11 * x3 <= 320)
    model.addConstr(11 * x0 <= 103)
    model.addConstr(6 * x1 <= 103)
    model.addConstr(2 * x2 <= 103)
    model.addConstr(11 * x3 <= 103)
    model.addConstr(9 * x0 + 12 * x2 >= 65)
    model.addConstr(9 * x0 + 9 * x3 >= 40)
    model.addConstr(9 * x0 + 9 * x1 >= 44)
    model.addConstr(9 * x1 + 9 * x3 >= 65)
    model.addConstr(9 * x1 + 12 * x2 >= 34)
    model.addConstr(9 * x0 + 9 * x1 + 12 * x2 >= 55)
    model.addConstr(9 * x0 + 12 * x2 + 9 * x3 >= 55)
    model.addConstr(9 * x1 + 12 * x2 + 9 * x3 >= 55)
    model.addConstr(9 * x0 + 9 * x1 + 12 * x2 >= 63)
    model.addConstr(9 * x0 + 12 * x2 + 9 * x3 >= 63)
    model.addConstr(9 * x1 + 12 * x2 + 9 * x3 >= 63)
    model.addConstr(9 * x0 + 9 * x1 + 12 * x2 >= 44)
    model.addConstr(9 * x0 + 12 * x2 + 9 * x3 >= 44)
    model.addConstr(9 * x1 + 12 * x2 + 9 * x3 >= 44)
    model.addConstr(9 * x0 + 9 * x1 + 12 * x2 + 9 * x3 >= 44)
    model.addConstr(9 * x0 + 10 * x2 >= 68)
    model.addConstr(11 * x1 + 11 * x3 >= 66)
    model.addConstr(9 * x0 + 11 * x1 >= 76)
    model.addConstr(9 * x0 + 10 * x2 + 11 * x3 >= 76)
    model.addConstr(9 * x0 + 11 * x1 + 10 * x2 + 11 * x3 >= 76)
    model.addConstr(6 * x1 + 2 * x2 >= 13)
    model.addConstr(2 * x2 + 11 * x3 >= 13)
    model.addConstr(11 * x0 + 2 * x2 >= 18)
    model.addConstr(11 * x0 + 6 * x1 + 2 * x2 + 11 * x3 >= 18)
    model.addConstr(-10 * x2 + 3 * x3 >= 0)
    model.addConstr(9 * x1 + 9 * x3 <= 169)
    model.addConstr(9 * x0 + 12 * x2 <= 178)
    model.addConstr(9 * x0 + 9 * x1 <= 228)
    model.addConstr(9 * x1 + 12 * x2 + 9 * x3 <= 91)
    model.addConstr(9 * x0 + 11 * x1 + 11 * x3 <= 86)
    model.addConstr(6 * x1 + 2 * x2 + 11 * x3 <= 26)
    model.addConstr(11 * x0 + 2 * x2 + 11 * x3 <= 62)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Dale: ", x0.varValue)
        print("Hours worked by Paul: ", x1.varValue)
        print("Hours worked by Laura: ", x2.varValue)
        print("Hours worked by John: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
