
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
bobby_hours = model.addVar(vtype=gp.GRB.INTEGER, name="bobby_hours")
bill_hours = model.addVar(vtype=gp.GRB.INTEGER, name="bill_hours")
peggy_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="peggy_hours")
mary_hours = model.addVar(vtype=gp.GRB.INTEGER, name="mary_hours")
paul_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="paul_hours")
john_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="john_hours")


# Set objective function
model.setObjective(6*bobby_hours*bill_hours + 3*bobby_hours*peggy_hours + 2*bobby_hours*paul_hours + 9*peggy_hours*john_hours + 9*mary_hours*john_hours + 8*paul_hours*john_hours + 3*bobby_hours + 3*bill_hours + 2*paul_hours, gp.GRB.MAXIMIZE)

# Add constraints

# Likelihood to quit index constraints
model.addConstr(19 * peggy_hours + 7 * paul_hours >= 51)
model.addConstr(22 * bill_hours**2 + 22 * peggy_hours**2 >= 79)
# ... (add all other likelihood to quit index constraints similarly)

# Computer competence rating constraints
model.addConstr(20 * peggy_hours + 6 * paul_hours >= 72)
model.addConstr(6 * paul_hours + 21 * john_hours >= 127)
# ... (add all other computer competence rating constraints similarly)


# Work quality rating constraints
model.addConstr(12 * mary_hours**2 + 22 * john_hours**2 >= 18)
model.addConstr(4 * bobby_hours + 4 * paul_hours + 22 * john_hours >= 23)
# ... (add all other work quality rating constraints similarly)


# Upper bound constraints (using resource data)
likelihood_to_quit_ub = 657
computer_competence_ub = 837
work_quality_ub = 268

model.addConstr(19*bobby_hours + 18*mary_hours <= 119)
model.addConstr(22*bill_hours**2 + 22*peggy_hours**2 <= 245)
model.addConstr(19*bobby_hours + 22*peggy_hours <= 652)
model.addConstr(19*bobby_hours + 22*bill_hours + 22*peggy_hours + 18*mary_hours + 7*paul_hours + 3*john_hours <= 652)
model.addConstr(5*bill_hours**2 + 6*paul_hours**2 <= 694)
model.addConstr(20*peggy_hours + 11*mary_hours <= 229)
model.addConstr(5*bill_hours + 20*peggy_hours <= 717)
model.addConstr(11*mary_hours + 6*paul_hours <= 828)
model.addConstr(12*bobby_hours + 5*bill_hours + 20*peggy_hours + 11*mary_hours + 6*paul_hours + 21*john_hours <= 828)
model.addConstr(5*peggy_hours + 22*john_hours <= 80)
model.addConstr(5*peggy_hours + 12*mary_hours <= 256)
model.addConstr(4*bobby_hours + 22*john_hours <= 240)
model.addConstr(12*mary_hours**2 + 4*paul_hours**2 <= 203)
model.addConstr(4*bobby_hours + 12*mary_hours <= 81)
model.addConstr(20*bill_hours**2 + 12*mary_hours**2 <= 252)
model.addConstr(12*mary_hours**2 + 22*john_hours**2 <= 140)
model.addConstr(4*bobby_hours**2 + 4*paul_hours**2 <= 247)
model.addConstr(4*bobby_hours + 20*bill_hours + 5*peggy_hours + 12*mary_hours + 4*paul_hours + 22*john_hours <= 247)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bobby hours: {bobby_hours.x}")
    print(f"Bill hours: {bill_hours.x}")
    print(f"Peggy hours: {peggy_hours.x}")
    print(f"Mary hours: {mary_hours.x}")
    print(f"Paul hours: {paul_hours.x}")
    print(f"John hours: {john_hours.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

