
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # hours worked by Bobby
x2 = m.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # hours worked by Bill
x3 = m.addVar(name='x3')  # hours worked by Peggy
x4 = m.addVar(name='x4', vtype=gurobi.GRB.INTEGER)  # hours worked by Mary
x5 = m.addVar(name='x5')  # hours worked by Paul
x6 = m.addVar(name='x6')  # hours worked by John

# Objective function
m.setObjective(6*x1*x2 + 3*x1*x3 + 2*x1*x5 + 9*x3*x6 + 9*x4*x6 + 8*x5*x6 + 3*x1 + 3*x2 + 2*x5, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(19*x1 <= 657)
m.addConstr(12*x1 <= 837)
m.addConstr(4*x1 <= 268)
m.addConstr(22*x2 <= 657)
m.addConstr(5*x2 <= 837)
m.addConstr(20*x2 <= 268)
m.addConstr(22*x3 <= 657)
m.addConstr(20*x3 <= 837)
m.addConstr(5*x3 <= 268)
m.addConstr(18*x4 <= 657)
m.addConstr(11*x4 <= 837)
m.addConstr(12*x4 <= 268)
m.addConstr(7*x5 <= 657)
m.addConstr(6*x5 <= 837)
m.addConstr(4*x5 <= 268)
m.addConstr(3*x6 <= 657)
m.addConstr(21*x6 <= 837)
m.addConstr(22*x6 <= 268)
m.addConstr(22*x3 + 7*x5 >= 51)
m.addConstr(x2**2 + x3**2 >= 79)
m.addConstr(18*x4 + 7*x5 >= 78)
m.addConstr(19*x1 + 7*x5 + 3*x6 >= 56)
m.addConstr(22*x3 + 7*x5 + 3*x6 >= 56)
m.addConstr(18*x4 + 22*x3 + 3*x6 >= 56)
m.addConstr(18*x4**2 + 7*x5**2 + 3*x6**2 >= 56)
m.addConstr(19*x1**2 + 22*x3**2 + 18*x4**2 >= 56)
m.addConstr(x2**2 + x3**2 + 18*x4**2 >= 56)

# Optimize
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objval)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
    print('x4: ', x4.varValue)
    print('x5: ', x5.varValue)
    print('x6: ', x6.varValue)
else:
    print('No solution found')
