
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")


# Set objective function
m.setObjective(2*peggy + 1*bill + 1*laura + 8*dale, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14*peggy + 6*dale >= 34)
m.addConstr(14*peggy + 1*laura >= 20)
m.addConstr(14*peggy + 8*bill >= 23)
m.addConstr(1*laura + 6*dale >= 37)
m.addConstr(14*peggy + 1*laura + 6*dale >= 29)
m.addConstr(8*bill + 1*laura + 6*dale >= 29)
m.addConstr(14*peggy + 1*laura + 6*dale >= 26)
m.addConstr(8*bill + 1*laura + 6*dale >= 26)
m.addConstr(14*peggy + 8*bill + 1*laura + 6*dale >= 26)
m.addConstr(5*bill + 1*dale >= 30)
m.addConstr(5*peggy + 1*dale >= 20)
m.addConstr(5*peggy + 3*laura >= 10)
m.addConstr(5*peggy + 5*bill + 1*dale >= 18)
m.addConstr(5*bill + 3*laura + 1*dale >= 18)
m.addConstr(5*peggy + 5*bill + 1*dale >= 29)
m.addConstr(5*bill + 3*laura + 1*dale >= 29)
m.addConstr(5*peggy + 5*bill + 3*laura + 1*dale >= 29)
m.addConstr(13*bill + 6*dale >= 10)
m.addConstr(13*bill + 2*laura >= 22)
m.addConstr(2*laura + 6*dale >= 15)
m.addConstr(11*peggy + 6*dale >= 25)
m.addConstr(11*peggy + 2*laura >= 29)
m.addConstr(11*peggy + 13*bill + 6*dale >= 32)
m.addConstr(13*bill + 2*laura + 6*dale >= 32)
m.addConstr(11*peggy + 13*bill + 6*dale >= 32)
m.addConstr(13*bill + 2*laura + 6*dale >= 32)
m.addConstr(11*peggy + 13*bill + 2*laura + 6*dale >= 32)
m.addConstr(14*peggy + 1*laura <= 112)
m.addConstr(14*peggy + 8*bill + 1*laura <= 133)
m.addConstr(14*peggy + 8*bill + 6*dale <= 148)
m.addConstr(14*peggy + 1*laura + 6*dale <= 172)
m.addConstr(3*laura + 1*dale <= 71)
m.addConstr(11*peggy + 13*bill + 6*dale <= 134)
m.addConstr(11*peggy + 13*bill + 2*laura <= 109)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

