
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Peggy
x1 = m.addVar(name="x1", lb=0)  # hours worked by Bill
x2 = m.addVar(name="x2", lb=0)  # hours worked by Laura
x3 = m.addVar(name="x3", lb=0)  # hours worked by Dale

# Define the objective function
m.setObjective(2 * (x0 + 1) * (x1 + 1) * x2 + 8 * x3, gurobi.GRB.MINIMIZE)

# Add constraints
# Individual ratings
m.addConstr(14 * x0 >= 14)
m.addConstr(5 * x0 >= 5)
m.addConstr(11 * x0 >= 11)
m.addConstr(8 * x1 >= 8)
m.addConstr(5 * x1 >= 5)
m.addConstr(13 * x1 >= 13)
m.addConstr(x2 >= 1)
m.addConstr(3 * x2 >= 3)
m.addConstr(2 * x2 >= 2)
m.addConstr(6 * x3 >= 6)
m.addConstr(x3 >= 1)
m.addConstr(6 * x3 >= 6)

# Combined productivity ratings
m.addConstr(14 * x0 + 6 * x3 >= 34)
m.addConstr(14 * x0 + x2 >= 20)
m.addConstr(14 * x0 + 8 * x1 >= 23)
m.addConstr(x2 + 6 * x3 >= 37)
m.addConstr(14 * x0 + x2 + 6 * x3 >= 29)
m.addConstr(8 * x1 + x2 + 6 * x3 >= 29)
m.addConstr(14 * x0 + x2 + 6 * x3 >= 26)
m.addConstr(8 * x1 + x2 + 6 * x3 >= 26)
m.addConstr(14 * x0 + 8 * x1 + x2 + 6 * x3 >= 26)

# Combined organization scores
m.addConstr(5 * x1 + x3 >= 30)
m.addConstr(5 * x0 + x3 >= 20)
m.addConstr(5 * x0 + 3 * x2 >= 10)
m.addConstr(5 * x0 + 5 * x1 + x3 >= 18)
m.addConstr(5 * x1 + 3 * x2 + x3 >= 18)
m.addConstr(5 * x0 + 5 * x1 + x3 >= 29)
m.addConstr(5 * x1 + 3 * x2 + x3 >= 29)
m.addConstr(5 * x0 + 5 * x1 + 3 * x2 + x3 >= 29)

# Combined paperwork competence ratings
m.addConstr(13 * x1 + 6 * x3 >= 10)
m.addConstr(13 * x1 + 2 * x2 >= 22)
m.addConstr(2 * x2 + 6 * x3 >= 15)
m.addConstr(11 * x0 + 6 * x3 >= 25)
m.addConstr(11 * x0 + 2 * x2 >= 29)
m.addConstr(11 * x0 + 13 * x1 + 6 * x3 >= 32)
m.addConstr(13 * x1 + 2 * x2 + 6 * x3 >= 32)
m.addConstr(11 * x0 + 13 * x1 + 6 * x3 >= 32)
m.addConstr(13 * x1 + 2 * x2 + 6 * x3 >= 32)
m.addConstr(11 * x0 + 13 * x1 + 2 * x2 + 6 * x3 >= 32)

# Bounds on combined ratings
m.addConstr(14 * x0 + x2 <= 112)
m.addConstr(14 * x0 + 8 * x1 + x2 <= 133)
m.addConstr(14 * x0 + 8 * x1 + 6 * x3 <= 148)
m.addConstr(14 * x0 + x2 + 6 * x3 <= 172)
m.addConstr(3 * x2 + x3 <= 71)
m.addConstr(11 * x0 + 13 * x1 + 6 * x3 <= 34)
m.addConstr(11 * x0 + 13 * x1 + 2 * x2 <= 109)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Hours worked by Peggy: ", x0.varValue)
    print("Hours worked by Bill: ", x1.varValue)
    print("Hours worked by Laura: ", x2.varValue)
    print("Hours worked by Dale: ", x3.varValue)
else:
    print("No optimal solution found")
