
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="x0") # hours worked by Mary
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # hours worked by Hank
    x2 = m.addVar(vtype=GRB.INTEGER, name="x2") # hours worked by John


    # Set objective function
    m.setObjective(5.15 * x0 + 6.39 * x1 + 4.5 * x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14 * x0 + 16 * x2 >= 8, "c0")
    m.addConstr(8 * x1 + 16 * x2 >= 10, "c1")
    m.addConstr(14 * x0 + 8 * x1 + 16 * x2 >= 10, "c2")
    m.addConstr(-9 * x0 + 7 * x2 >= 0, "c3")
    m.addConstr(5 * x1 - 4 * x2 >= 0, "c4")
    m.addConstr(8 * x1 + 16 * x2 <= 25, "c5")
    m.addConstr(14 * x0 + 8 * x1 + 16 * x2 <= 44, "c6")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
