
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x1 = model.addVar(name="hours_worked_by_Mary", vtype=gurobi.GRB.INTEGER)  # Non-fractional hours worked by Mary
x2 = model.addVar(name="hours_worked_by_Hank", vtype=gurobi.GRB.CONTINUOUS)  # Fractional hours worked by Hank
x3 = model.addVar(name="hours_worked_by_John", vtype=gurobi.GRB.INTEGER)  # Integer hours worked by John

# Objective function
model.setObjective(5.15 * x1 + 6.39 * x2 + 4.5 * x3, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(14 * x1 <= 45, name="Mary_productivity")
model.addConstr(8 * x2 <= 45, name="Hank_productivity")
model.addConstr(16 * x3 <= 45, name="John_productivity")

model.addConstr(14 * x1 + 16 * x3 >= 8, name="Mary_John_min_productivity")
model.addConstr(8 * x2 + 16 * x3 >= 10, name="Hank_John_min_productivity")
model.addConstr(14 * x1 + 8 * x2 + 16 * x3 >= 10, name="Total_min_productivity")

model.addConstr(-9 * x1 + 7 * x3 >= 0, name="Mary_John_tradeoff")
model.addConstr(5 * x2 - 4 * x3 >= 0, name="Hank_John_tradeoff")

model.addConstr(8 * x2 + 16 * x3 <= 25, name="Hank_John_max_productivity")
model.addConstr(14 * x1 + 8 * x2 + 16 * x3 <= 44, name="Total_max_productivity")

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Hours worked by Mary: ", x1.varValue)
    print("Hours worked by Hank: ", x2.varValue)
    print("Hours worked by John: ", x3.varValue)
else:
    print("No optimal solution found")
