
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
bill_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
paul_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")
jean_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean_hours")
john_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john_hours")


# Set objective function
m.setObjective(9.48 * bill_hours + 8.51 * paul_hours + 9.45 * jean_hours + 7.27 * john_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * jean_hours + 5 * john_hours >= 10)
m.addConstr(4 * paul_hours + 3 * jean_hours >= 6)
m.addConstr(3 * bill_hours + 4 * paul_hours + 3 * jean_hours >= 7)
m.addConstr(2 * paul_hours + 4 * john_hours >= 12)
m.addConstr(1 * bill_hours + 4 * jean_hours >= 6)

m.addConstr(2 * bill_hours + 4 * paul_hours + 2 * jean_hours >= 17)
m.addConstr(2 * bill_hours + 2 * jean_hours + 1 * john_hours >= 17)
m.addConstr(2 * bill_hours + 4 * paul_hours + 1 * john_hours >= 17)
m.addConstr(4 * paul_hours + 2 * jean_hours + 1 * john_hours >= 17)

m.addConstr(1 * paul_hours + 1 * jean_hours >= 15)
m.addConstr(5 * bill_hours + 3 * john_hours >= 15)
m.addConstr(1 * jean_hours + 3 * john_hours >= 5)
m.addConstr(5 * bill_hours + 1 * jean_hours >= 12)
m.addConstr(5 * bill_hours + 1 * paul_hours >= 15)
m.addConstr(1 * paul_hours + 3 * john_hours >= 7)
m.addConstr(5 * bill_hours + 1 * paul_hours + 3 * john_hours >= 11)


m.addConstr(3 * jean_hours + 5 * john_hours <= 39)
m.addConstr(4 * paul_hours + 3 * jean_hours <= 18)
m.addConstr(3 * bill_hours + 4 * paul_hours <= 12)
m.addConstr(3 * bill_hours + 4 * paul_hours + 3 * jean_hours <= 16)
m.addConstr(3 * bill_hours + 4 * paul_hours + 3 * jean_hours + 5 * john_hours <= 16)

m.addConstr(2 * paul_hours + 4 * jean_hours <= 41)
m.addConstr(1 * bill_hours + 4 * jean_hours <= 49)
m.addConstr(2 * paul_hours + 4 * john_hours <= 19)
m.addConstr(1 * bill_hours + 2 * paul_hours + 4 * jean_hours + 4 * john_hours <= 19)

m.addConstr(2 * bill_hours + 1 * john_hours <= 60)
m.addConstr(2 * bill_hours + 2 * jean_hours <= 36)
m.addConstr(4 * paul_hours + 2 * jean_hours <= 39)
m.addConstr(2 * bill_hours + 4 * paul_hours + 1 * john_hours <= 37)
m.addConstr(2 * bill_hours + 2 * jean_hours + 1 * john_hours <= 33)
m.addConstr(4 * paul_hours + 2 * jean_hours + 1 * john_hours <= 48)
m.addConstr(2 * bill_hours + 4 * paul_hours + 2 * jean_hours <= 19)
m.addConstr(2 * bill_hours + 4 * paul_hours + 2 * jean_hours + 1 * john_hours <= 19)


m.addConstr(5 * bill_hours + 1 * jean_hours <= 64)
m.addConstr(1 * jean_hours + 3 * john_hours <= 35)
m.addConstr(1 * paul_hours + 1 * jean_hours <= 43)
m.addConstr(1 * paul_hours + 1 * jean_hours + 3 * john_hours <= 33)
m.addConstr(5 * bill_hours + 1 * paul_hours + 1 * jean_hours + 3 * john_hours <= 33)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

