
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Bill
x1 = m.addVar(name="x1", lb=0)  # hours worked by Paul
x2 = m.addVar(name="x2", lb=0)  # hours worked by Jean
x3 = m.addVar(name="x3", lb=0)  # hours worked by John

# Define the objective function
m.setObjective(9.48 * x0 + 8.51 * x1 + 9.45 * x2 + 7.27 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * x0 <= 45)
m.addConstr(1 * x0 <= 62)
m.addConstr(2 * x0 <= 72)
m.addConstr(5 * x0 <= 66)

m.addConstr(4 * x1 <= 45)
m.addConstr(2 * x1 <= 62)
m.addConstr(4 * x1 <= 72)
m.addConstr(1 * x1 <= 66)

m.addConstr(3 * x2 <= 45)
m.addConstr(4 * x2 <= 62)
m.addConstr(2 * x2 <= 72)
m.addConstr(1 * x2 <= 66)

m.addConstr(5 * x3 <= 45)
m.addConstr(4 * x3 <= 62)
m.addConstr(1 * x3 <= 72)
m.addConstr(3 * x3 <= 66)

m.addConstr(3 * x2 + 5 * x3 >= 10)
m.addConstr(4 * x1 + 3 * x2 >= 6)
m.addConstr(3 * x0 + 4 * x1 + 3 * x2 >= 7)
m.addConstr(2 * x1 + 4 * x3 >= 12)
m.addConstr(1 * x0 + 4 * x2 >= 6)

m.addConstr(2 * x0 + 4 * x1 + 2 * x2 >= 15)
m.addConstr(2 * x0 + 2 * x2 + 1 * x3 >= 15)
m.addConstr(2 * x0 + 4 * x1 + 1 * x3 >= 15)
m.addConstr(4 * x1 + 2 * x2 + 1 * x3 >= 15)

m.addConstr(2 * x0 + 4 * x1 + 2 * x2 >= 14)
m.addConstr(2 * x0 + 2 * x2 + 1 * x3 >= 14)
m.addConstr(2 * x0 + 4 * x1 + 1 * x3 >= 14)
m.addConstr(4 * x1 + 2 * x2 + 1 * x3 >= 14)

m.addConstr(2 * x0 + 4 * x1 + 2 * x2 >= 15)
m.addConstr(2 * x0 + 2 * x2 + 1 * x3 >= 15)
m.addConstr(2 * x0 + 4 * x1 + 1 * x3 >= 15)
m.addConstr(4 * x1 + 2 * x2 + 1 * x3 >= 15)

m.addConstr(2 * x0 + 4 * x1 + 2 * x2 >= 17)
m.addConstr(2 * x0 + 2 * x2 + 1 * x3 >= 17)
m.addConstr(2 * x0 + 4 * x1 + 1 * x3 >= 17)
m.addConstr(4 * x1 + 2 * x2 + x3 >= 17)

m.addConstr(1 * x1 + 1 * x2 >= 15)
m.addConstr(5 * x0 + 3 * x3 >= 15)
m.addConstr(1 * x2 + 3 * x3 >= 5)
m.addConstr(5 * x0 + 1 * x2 >= 12)
m.addConstr(5 * x0 + 1 * x1 >= 15)
m.addConstr(1 * x1 + 3 * x3 >= 7)
m.addConstr(5 * x0 + 1 * x1 + 3 * x3 >= 11)

m.addConstr(3 * x2 + 5 * x3 <= 39)
m.addConstr(4 * x1 + 3 * x2 <= 18)
m.addConstr(3 * x0 + 4 * x1 <= 12)
m.addConstr(3 * x0 + 4 * x1 + 3 * x2 <= 16)
m.addConstr(3 * x0 + 4 * x1 + 3 * x2 + 5 * x3 <= 16)

m.addConstr(2 * x1 + 4 * x2 <= 41)
m.addConstr(1 * x0 + 4 * x2 <= 49)
m.addConstr(2 * x1 + 4 * x3 <= 19)
m.addConstr(9.48 * x0 + 8.51 * x1 + 9.45 * x2 + 7.27 * x3 <= 19)

m.addConstr(2 * x0 + 1 * x3 <= 60)
m.addConstr(2 * x0 + 9.45 * x2 <= 36)
m.addConstr(4 * x1 + 4 * x2 <= 39)
m.addConstr(2 * x0 + 4 * x1 + 1 * x3 <= 37)
m.addConstr(2 * x0 + 4 * x2 + 1 * x3 <= 33)
m.addConstr(4 * x1 + 4 * x2 + 1 * x3 <= 48)

m.addConstr(2 * x0 + 4 * x1 + 2 * x2 <= 19)
m.addConstr(2 * x0 + 4 * x1 + 2 * x2 + 1 * x3 <= 19)

m.addConstr(5 * x0 + 1 * x2 <= 64)
m.addConstr(1 * x2 + 3 * x3 <= 35)
m.addConstr(1 * x1 + 1 * x2 <= 43)
m.addConstr(1 * x1 + 1 * x2 + 3 * x3 <= 33)
m.addConstr(5 * x0 + 1 * x1 + 1 * x2 + 3 * x3 <= 33)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("No solution found")
