
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1")
    x2 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x2")
    x3 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x3")


    # Set objective function
    model.setObjective(3*x0 + 6*x1 + 1*x2 + 5*x3, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3*x0 + 29*x3 >= 25)
    model.addConstr(21*x1 + 8*x2 >= 43)
    model.addConstr(3*x0 + 8*x2 >= 44)
    model.addConstr(3*x0 + 21*x1 + 29*x3 >= 41)
    model.addConstr(3*x0 + 21*x1 + 8*x2 >= 41)
    model.addConstr(21*x1 + 8*x2 + 29*x3 >= 41)
    model.addConstr(3*x0 + 21*x1 + 29*x3 >= 47)
    model.addConstr(3*x0 + 21*x1 + 8*x2 >= 47)
    model.addConstr(21*x1 + 8*x2 + 29*x3 >= 47)
    model.addConstr(3*x0 + 21*x1 + 29*x3 >= 52)
    model.addConstr(3*x0 + 21*x1 + 8*x2 >= 52)
    model.addConstr(21*x1 + 8*x2 + 29*x3 >= 52)
    model.addConstr(3*x0 + 21*x1 + 8*x2 + 29*x3 >= 52)
    model.addConstr(27*x0 + 21*x1 >= 49)
    model.addConstr(27*x0 + 18*x3 >= 56)
    model.addConstr(27*x0 + 21*x1 + 26*x2 + 18*x3 >= 56)
    model.addConstr(-9*x2 + 7*x3 >= 0)
    model.addConstr(-2*x0 + 1*x3 >= 0)
    model.addConstr(3*x0 + 21*x1 + 8*x2 <= 104)
    model.addConstr(21*x1 + 8*x2 + 29*x3 <= 105)
    model.addConstr(3*x0 + 21*x1 + 29*x3 <= 128)
    model.addConstr(27*x0 + 26*x2 <= 331)
    model.addConstr(27*x0 + 21*x1 + 18*x3 <= 364)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
