
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(lb=0, name="hours_worked_by_Paul")  # Can be non-integer
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours_worked_by_Mary")  # Must be integer
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours_worked_by_John")  # Must be integer
x3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours_worked_by_Laura")  # Must be integer

# Define the objective function
m.setObjective(3*x0 + 6*x1 + x2 + 5*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x0 + 29*x3 >= 25)
m.addConstr(21*x1 + 8*x2 >= 43)
m.addConstr(3*x0 + 8*x2 >= 44)
m.addConstr(3*x0 + 21*x1 + 29*x3 >= 41)
m.addConstr(3*x0 + 21*x1 + 8*x2 >= 41)
m.addConstr(21*x1 + 8*x2 + 29*x3 >= 41)
m.addConstr(3*x0 + 21*x1 + 29*x3 >= 47)
m.addConstr(3*x0 + 21*x1 + 8*x2 >= 47)
m.addConstr(21*x1 + 8*x2 + 29*x3 >= 47)
m.addConstr(3*x0 + 21*x1 + 29*x3 >= 52)
m.addConstr(3*x0 + 21*x1 + 8*x2 >= 52)
m.addConstr(21*x1 + 8*x2 + 29*x3 >= 52)
m.addConstr(3*x0 + 21*x1 + 8*x2 + 29*x3 >= 52)
m.addConstr(27*x0 + 21*x1 >= 49)
m.addConstr(27*x0 + 18*x3 >= 56)
m.addConstr(27*x0 + 21*x1 + 26*x2 + 18*x3 >= 56)
m.addConstr(-9*x2 + 7*x3 >= 0)
m.addConstr(-2*x0 + x3 >= 0)
m.addConstr(3*x0 + 21*x1 + 8*x2 <= 104)
m.addConstr(21*x1 + 8*x2 + 29*x3 <= 105)
m.addConstr(3*x0 + 21*x1 + 29*x3 <= 128)
m.addConstr(27*x0 + 26*x2 <= 331)
m.addConstr(27*x0 + 21*x1 + 18*x3 <= 364)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Paul: ", x0.varValue)
    print("Hours worked by Mary: ", x1.varValue)
    print("Hours worked by John: ", x2.varValue)
    print("Hours worked by Laura: ", x3.varValue)
else:
    print("The model is infeasible")
