
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    ringo_hours = model.addVar(lb=0, name="ringo_hours")  # Non-negative hours
    john_hours = model.addVar(lb=0, name="john_hours")    # Non-negative hours


    # Set objective function
    model.setObjective(3.08 * ringo_hours + 8.47 * john_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12 * ringo_hours + 19 * john_hours >= 11, "dollar_cost_min")
    model.addConstr(23 * ringo_hours + 12 * john_hours >= 22, "competence_min")
    model.addConstr(-10 * ringo_hours + 6 * john_hours >= 0, "ringo_john_relation")
    model.addConstr(12 * ringo_hours + 19 * john_hours <= 47, "dollar_cost_max")
    model.addConstr(23 * ringo_hours + 12 * john_hours <= 29, "competence_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    # Print solution if feasible
    elif model.status == gp.GRB.OPTIMAL:
        print("Optimal solution found:")
        print(f"Hours worked by Ringo: {ringo_hours.x}")
        print(f"Hours worked by John: {john_hours.x}")
        print(f"Objective value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

