
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name="hours_worked_by_Ringo", lb=0)
x2 = m.addVar(name="hours_worked_by_John", lb=0)

# Set the objective function
m.setObjective(3.08*x1 + 8.47*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x1 + 19*x2 >= 11, name="min_total_dollar_cost")
m.addConstr(23*x1 + 12*x2 >= 22, name="min_total_competence")
m.addConstr(-10*x1 + 6*x2 >= 0, name="linear_constraint")
m.addConstr(12*x1 + 19*x2 <= 47, name="max_total_dollar_cost")
m.addConstr(23*x1 + 12*x2 <= 29, name="max_total_competence")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Ringo: {x1.x}")
    print(f"Hours worked by John: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
