
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_Ringo", lb=0)
    x2 = model.addVar(name="hours_worked_by_John", lb=0)

    # Define the objective function
    model.setObjective(3.08 * x1 + 8.47 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12 * x1 + 19 * x2 >= 11)
    model.addConstr(23 * x1 + 12 * x2 >= 22)
    model.addConstr(-10 * x1 + 6 * x2 >= 0)
    model.addConstr(12 * x1 + 19 * x2 <= 47)
    model.addConstr(23 * x1 + 12 * x2 <= 29)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Ringo: {x1.varValue}")
        print(f"Hours worked by John: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
