
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")


    # Set objective function
    model.setObjective(7.57 * x0 + 7.11 * x1 + 7.21 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5 * x0 + 18 * x1 + 7 * x2 <= 173, "c0")
    model.addConstr(5 * x0 + 11 * x1 + 18 * x2 <= 132, "c1")
    model.addConstr(1 * x0 + 13 * x1 + 16 * x2 <= 203, "c2")
    model.addConstr(17 * x0 + 12 * x1 + 20 * x2 <= 107, "c3")
    model.addConstr(5 * x0 + 11 * x1 + 18 * x2 >= 38, "c4")
    model.addConstr(1 * x0 + 16 * x2 >= 59, "c5")
    model.addConstr(1 * x0 + 13 * x1 + 16 * x2 >= 62, "c6")
    model.addConstr(5 * x0 + 7 * x2 <= 102, "c7")
    model.addConstr(18 * x1 + 7 * x2 <= 122, "c8")
    model.addConstr(5 * x0 + 18 * x1 + 7 * x2 <= 157, "c9")
    model.addConstr(5 * x0 + 18 * x2 <= 110, "c10")
    model.addConstr(11 * x1 + 18 * x2 <= 108, "c11")
    model.addConstr(13 * x1 + 16 * x2 <= 98, "c12")
    model.addConstr(1 * x0 + 13 * x1 <= 83, "c13")
    model.addConstr(1 * x0 + 13 * x1 + 16 * x2 <= 83, "c14")
    model.addConstr(17 * x0 + 12 * x1 <= 107, "c15")
    model.addConstr(17 * x0 + 20 * x2 <= 49, "c16")
    model.addConstr(17 * x0 + 12 * x1 + 20 * x2 <= 107, "c17")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
