
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of potassium
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B12
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin A

    # Objective function
    model.setObjective(7.57 * x0 + 7.11 * x1 + 7.21 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * x0 <= 173)
    model.addConstr(5 * x0 <= 132)
    model.addConstr(x0 <= 203)
    model.addConstr(17 * x0 <= 107)

    model.addConstr(18 * x1 <= 173)
    model.addConstr(11 * x1 <= 132)
    model.addConstr(13 * x1 <= 203)
    model.addConstr(12 * x1 <= 107)

    model.addConstr(7 * x2 <= 173)
    model.addConstr(18 * x2 <= 132)
    model.addConstr(16 * x2 <= 203)
    model.addConstr(20 * x2 <= 107)

    model.addConstr(5 * x0 + 11 * x1 + 18 * x2 >= 38)
    model.addConstr(x0 + 16 * x2 >= 59)
    model.addConstr(x0 + 13 * x1 + 16 * x2 >= 62)

    model.addConstr(5 * x0 + 7 * x2 <= 102)
    model.addConstr(18 * x1 + 7 * x2 <= 122)
    model.addConstr(5 * x0 + 18 * x1 + 7 * x2 <= 157)

    model.addConstr(5 * x0 + 18 * x2 <= 110)
    model.addConstr(11 * x1 + 18 * x2 <= 108)
    model.addConstr(5 * x0 + 11 * x1 + 18 * x2 <= 108)

    model.addConstr(13 * x1 + 16 * x2 <= 98)
    model.addConstr(x0 + 13 * x1 <= 83)
    model.addConstr(x0 + 13 * x1 + 16 * x2 <= 83)

    model.addConstr(17 * x0 + 12 * x1 <= 107)
    model.addConstr(17 * x0 + 20 * x2 <= 49)
    model.addConstr(17 * x0 + 12 * x1 + 20 * x2 <= 107)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of potassium: {x0.varValue}")
        print(f"Milligrams of vitamin B12: {x1.varValue}")
        print(f"Milligrams of vitamin A: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
