
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="deployed_decoys")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="SOC_operators")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")


    # Set objective function
    m.setObjective(9.54 * x0 + 1.59 * x1 + 8.77 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7 * x0 <= 97, "c0")
    m.addConstr(5 * x0 <= 112, "c1")
    m.addConstr(1 * x1 <= 97, "c2")
    m.addConstr(3 * x1 <= 112, "c3")
    m.addConstr(11 * x2 <= 97, "c4")
    m.addConstr(5 * x2 <= 112, "c5")
    m.addConstr(x1 + 11 * x2 >= 12, "c6")
    m.addConstr(7 * x0 + x1 >= 24, "c7")
    m.addConstr(7 * x0 + x1 + 11 * x2 >= 24, "c8")
    m.addConstr(3 * x1 + 5 * x2 >= 25, "c9")
    m.addConstr(5 * x0 + 3 * x1 >= 20, "c10")
    m.addConstr(5 * x0 + 3 * x1 + 5 * x2 >= 20, "c11")
    m.addConstr(9 * x0 - 8 * x2 >= 0, "c12")
    m.addConstr(5 * x1 - 2 * x2 >= 0, "c13")
    m.addConstr(7 * x0 +  x1 <= 96, "c14")
    m.addConstr(x1 + 11 * x2 <= 38, "c15")
    m.addConstr(7 * x0 + 11 * x2 <= 81, "c16")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
