
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="deployed_decoys", vtype=gurobi.GRB.INTEGER)  # deployed decoys
    x1 = model.addVar(name="SOC_operators", vtype=gurobi.GRB.INTEGER)  # SOC operators
    x2 = model.addVar(name="honeypots", vtype=gurobi.GRB.INTEGER)    # honeypots

    # Objective function
    model.setObjective(9.54 * x0 + 1.59 * x1 + 8.77 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x0 == 1)  # data integrity impact of deployed decoys is 7
    model.addConstr(x1 + 11 * x2 >= 12)  # total combined data integrity impact from SOC operators plus honeypots
    model.addConstr(7 * x0 + x1 >= 24)  # total combined data integrity impact from deployed decoys plus SOC operators
    model.addConstr(7 * x0 + x1 + 11 * x2 >= 24)  # total combined data integrity impact from all
    model.addConstr(3 * x1 + 5 * x2 >= 25)  # power consumption of SOC operators plus honeypots
    model.addConstr(5 * x0 + 3 * x1 >= 20)  # power consumption of deployed decoys and SOC operators
    model.addConstr(5 * x0 + 3 * x1 + 5 * x2 >= 20)  # power consumption of all
    model.addConstr(9 * x0 - 8 * x2 >= 0)  # specific constraint
    model.addConstr(5 * x1 - 2 * x2 >= 0)  # specific constraint
    model.addConstr(7 * x0 + x1 <= 96)  # data integrity impact constraint
    model.addConstr(x1 + 11 * x2 <= 38)  # data integrity impact constraint
    model.addConstr(7 * x0 + 11 * x2 <= 81)  # data integrity impact constraint

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Deployed decoys: ", x0.varValue)
        print("SOC operators: ", x1.varValue)
        print("Honeypots: ", x2.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
