
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
cbrn_platoons = m.addVar(vtype=gp.GRB.INTEGER, name="cbrn_platoons")
pathfinder_teams = m.addVar(vtype=gp.GRB.INTEGER, name="pathfinder_teams")
reconnaissance_troops = m.addVar(vtype=gp.GRB.INTEGER, name="reconnaissance_troops")
air_defense_batteries = m.addVar(vtype=gp.GRB.INTEGER, name="air_defense_batteries")

# Set objective function
m.setObjective(5.76 * cbrn_platoons + 6.85 * pathfinder_teams + 3.94 * reconnaissance_troops + 1.01 * air_defense_batteries, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18 * pathfinder_teams + 10 * air_defense_batteries >= 37)
m.addConstr(1 * reconnaissance_troops + 10 * air_defense_batteries >= 36)
m.addConstr(18 * cbrn_platoons + 8 * pathfinder_teams + 1 * reconnaissance_troops + 10 * air_defense_batteries >= 36)
m.addConstr(11 * pathfinder_teams + 8 * reconnaissance_troops >= 20)
m.addConstr(11 * pathfinder_teams + 1 * air_defense_batteries >= 22)
m.addConstr(7 * cbrn_platoons + 8 * reconnaissance_troops >= 29)
m.addConstr(7 * cbrn_platoons + 11 * pathfinder_teams + 8 * reconnaissance_troops >= 32)
m.addConstr(7 * cbrn_platoons + 8 * reconnaissance_troops + 1 * air_defense_batteries >= 32)
m.addConstr(7 * cbrn_platoons + 11 * pathfinder_teams + 8 * reconnaissance_troops >= 43)
m.addConstr(7 * cbrn_platoons + 8 * reconnaissance_troops + 1 * air_defense_batteries >= 43)
m.addConstr(7 * cbrn_platoons + 11 * pathfinder_teams + 8 * reconnaissance_troops + 1 * air_defense_batteries >= 43)
m.addConstr(13 * cbrn_platoons + 19 * air_defense_batteries >= 28)
m.addConstr(13 * cbrn_platoons + 4 * reconnaissance_troops + 19 * air_defense_batteries >= 24)
m.addConstr(13 * cbrn_platoons + 2 * pathfinder_teams + 4 * reconnaissance_troops + 19 * air_defense_batteries >= 24)
m.addConstr(-1 * cbrn_platoons + 8 * pathfinder_teams >= 0)
m.addConstr(18 * cbrn_platoons + 8 * pathfinder_teams <= 160)
m.addConstr(1 * reconnaissance_troops + 10 * air_defense_batteries <= 151)
m.addConstr(8 * pathfinder_teams + 1 * reconnaissance_troops <= 176)
m.addConstr(18 * cbrn_platoons + 1 * reconnaissance_troops + 10 * air_defense_batteries <= 178)
m.addConstr(8 * pathfinder_teams + 1 * reconnaissance_troops + 10 * air_defense_batteries <= 127)
m.addConstr(18 * cbrn_platoons + 8 * pathfinder_teams + 10 * air_defense_batteries <= 79)
m.addConstr(7 * cbrn_platoons + 11 * pathfinder_teams + 1 * air_defense_batteries <= 165)
m.addConstr(7 * cbrn_platoons + 8 * reconnaissance_troops + 1 * air_defense_batteries <= 63)
m.addConstr(2 * pathfinder_teams + 19 * air_defense_batteries <= 140)
m.addConstr(13 * cbrn_platoons + 4 * reconnaissance_troops <= 153)
m.addConstr(4 * reconnaissance_troops + 19 * air_defense_batteries <= 117)
m.addConstr(2 * pathfinder_teams + 4 * reconnaissance_troops <= 120)


# Resource Constraints
m.addConstr(18 * cbrn_platoons <= 196)
m.addConstr(7 * cbrn_platoons <= 184)
m.addConstr(13 * cbrn_platoons <= 175)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

