
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name='CBRN_platoons', vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name='pathfinder_teams', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='reconnaissance_troops', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='air_defense_batteries', vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(5.76*x0 + 6.85*x1 + 3.94*x2 + 1.01*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8*x1 + 10*x3 >= 37)
    model.addConstr(1*x2 + 10*x3 >= 36)
    model.addConstr(18*x0 + 8*x1 + 1*x2 + 10*x3 >= 36)
    model.addConstr(11*x1 + 8*x2 >= 20)
    model.addConstr(11*x1 + 1*x3 >= 22)
    model.addConstr(7*x0 + 8*x2 >= 29)
    model.addConstr(7*x0 + 11*x1 + 8*x2 >= 32)
    model.addConstr(7*x0 + 8*x2 + 1*x3 >= 32)
    model.addConstr(7*x0 + 11*x1 + 8*x2 >= 43)
    model.addConstr(7*x0 + 8*x2 + 1*x3 >= 43)
    model.addConstr(7*x0 + 11*x1 + 8*x2 + 1*x3 >= 43)
    model.addConstr(13*x0 + 19*x3 >= 28)
    model.addConstr(13*x0 + 4*x2 + 19*x3 >= 24)
    model.addConstr(13*x0 + 2*x1 + 4*x2 + 19*x3 >= 24)
    model.addConstr(-1*x0 + 8*x1 >= 0)
    model.addConstr(18*x0 + 8*x1 <= 160)
    model.addConstr(1*x2 + 10*x3 <= 151)
    model.addConstr(8*x1 + 1*x2 <= 176)
    model.addConstr(18*x0 + 1*x2 + 10*x3 <= 178)
    model.addConstr(8*x1 + 1*x2 + 10*x3 <= 127)
    model.addConstr(18*x0 + 8*x1 + 10*x3 <= 79)
    model.addConstr(7*x0 + 11*x1 + 1*x3 <= 165)
    model.addConstr(7*x0 + 8*x2 + 1*x3 <= 63)
    model.addConstr(2*x1 + 19*x3 <= 140)
    model.addConstr(13*x0 + 4*x2 <= 153)
    model.addConstr(4*x2 + 19*x3 <= 117)
    model.addConstr(2*x1 + 4*x2 <= 120)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('CBRN platoons: ', x0.varValue)
        print('pathfinder teams: ', x1.varValue)
        print('reconnaissance troops: ', x2.varValue)
        print('air defense batteries: ', x3.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
