
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.CONTINUOUS, name="x0")
    x1 = m.addVar(vtype=GRB.INTEGER, name="x1")
    x2 = m.addVar(vtype=GRB.INTEGER, name="x2")

    # Set objective function
    m.setObjective(5.95*x0**2 + 6.36*x0*x1 + 6.77*x0*x2 + 6.34*x1**2 + 3.22*x1*x2 + 8.3*x2**2 + 5.13*x1 + 5.06*x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8*x0 + 1*x1 + 2*x2 <= 109, "c0")
    m.addConstr(11*x0 + 3*x1 + 8*x2 <= 62, "c1")
    m.addConstr(2*x0 + 1*x1 + 3*x2 <= 67, "c2")
    m.addConstr(8*x0 + 1*x1 >= 36, "c3")
    m.addConstr(8*x0 + 2*x2 >= 30, "c4")
    m.addConstr(8*x0 + 1*x1 + 2*x2 >= 20, "c5")
    m.addConstr(11*x0 + 8*x2 >= 12, "c6")
    m.addConstr(2*x0 + 1*x1 >= 9, "c7")
    m.addConstr(2*x0 + 3*x2 >= 19, "c8")
    m.addConstr(1*x1 + 3*x2 >= 17, "c9")
    m.addConstr(2*x0 + 1*x1 + 3*x2 >= 13, "c10")
    m.addConstr(8*x0 + 2*x2 <= 42, "c11")
    m.addConstr(8*x0**2 + 1*x1**2 <= 102, "c12")
    m.addConstr(8*x0 + 1*x1 + 2*x2 <= 102, "c13")
    m.addConstr(3*x1**2 + 8*x2**2 <= 31, "c14")
    m.addConstr(11*x0 + 8*x2 <= 25, "c15")
    m.addConstr(11*x0 + 3*x1 + 8*x2 <= 25, "c16")
    m.addConstr(2*x0**2 + 3*x2**2 <= 46, "c17")
    m.addConstr(2*x0 + 1*x1 <= 63, "c18")
    m.addConstr(2*x0 + 1*x1 + 3*x2 <= 63, "c19")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
