
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # milligrams of vitamin B1
x2 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x2")  # grams of fat
x3 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin B5

# Objective function
m.setObjective(5.95*x1**2 + 6.36*x1*x2 + 6.77*x1*x3 + 6.34*x2**2 + 3.22*x2*x3 + 8.3*x3**2 + 5.13*x2 + 5.06*x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(8*x1 <= 109)
m.addConstr(11*x1 <= 62)
m.addConstr(2*x1 <= 67)
m.addConstr(1*x2 <= 109)
m.addConstr(3*x2 <= 62)
m.addConstr(1*x2 <= 67)
m.addConstr(2*x3 <= 109)
m.addConstr(8*x3 <= 62)
m.addConstr(3*x3 <= 67)
m.addConstr(8*x1 + 1*x2 >= 36)
m.addConstr(8*x1 + 2*x3 >= 30)
m.addConstr(8*x1 + 1*x2 + 2*x3 >= 20)
m.addConstr(11*x1 + 8*x3 >= 12)
m.addConstr(2*x1 + 1*x2 >= 9)
m.addConstr(2*x1 + 3*x3 >= 19)
m.addConstr(1*x2 + 3*x3 >= 17)
m.addConstr(2*x1 + 1*x2 + 3*x3 >= 13)
m.addConstr(8*x1 + 2*x3 <= 42)
m.addConstr(8**2*x1**2 + 1**2*x2**2 <= 102)
m.addConstr(8*x1 + 1*x2 + 2*x3 <= 102)
m.addConstr(3**2*x2**2 + 8**2*x3**2 <= 31)
m.addConstr(11*x1 + 8*x3 <= 25)
m.addConstr(11*x1 + 3*x2 + 8*x3 <= 25)
m.addConstr(2**2*x1**2 + 3**2*x3**2 <= 46)
m.addConstr(2*x1 + 1*x2 <= 63)
m.addConstr(2*x1 + 1*x2 + 3*x3 <= 63)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
