
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
cheeseburgers = model.addVar(vtype=GRB.INTEGER, name="cheeseburgers")
bowls_of_cereal = model.addVar(vtype=GRB.INTEGER, name="bowls_of_cereal")

# Set objective function
model.setObjective(9.54 * cheeseburgers + 3.68 * bowls_of_cereal, GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * cheeseburgers + 6 * bowls_of_cereal >= 52, "iron_min")
model.addConstr(11 * cheeseburgers + 7 * bowls_of_cereal >= 20, "umami_min")
model.addConstr(16 * cheeseburgers + 16 * bowls_of_cereal >= 26, "healthiness_min")
model.addConstr(7 * cheeseburgers + 5 * bowls_of_cereal >= 44, "tastiness_min")
model.addConstr(-2 * cheeseburgers + 3 * bowls_of_cereal >= 0, "custom_constraint_1")
model.addConstr(2 * cheeseburgers + 6 * bowls_of_cereal <= 67, "iron_max")
model.addConstr(11 * cheeseburgers + 7 * bowls_of_cereal <= 28, "umami_max")
model.addConstr(16 * cheeseburgers + 16 * bowls_of_cereal <= 53, "healthiness_max")
model.addConstr(7 * cheeseburgers + 5 * bowls_of_cereal <= 77, "tastiness_max")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal objective value:', model.objVal)
    print('cheeseburgers:', cheeseburgers.x)
    print('bowls_of_cereal:', bowls_of_cereal.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization ended with status {model.status}")

