
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables as integers
x0 = m.addVar(vtype=GRB.INTEGER, name="cheeseburgers")
x1 = m.addVar(vtype=GRB.INTEGER, name="bowls_of_cereal")

# Set the objective function
m.setObjective(9.54*x0 + 3.68*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x0 + 6*x1 >= 52, "iron_min")
m.addConstr(2*x0 + 6*x1 <= 67, "iron_max")
m.addConstr(11*x0 + 7*x1 >= 20, "umami_min")
m.addConstr(11*x0 + 7*x1 <= 28, "umami_max")
m.addConstr(16*x0 + 16*x1 >= 26, "healthiness_min")
m.addConstr(16*x0 + 16*x1 <= 53, "healthiness_max")
m.addConstr(7*x0 + 5*x1 >= 44, "tastiness_min")
m.addConstr(7*x0 + 5*x1 <= 77, "tastiness_max")
m.addConstr(-2*x0 + 3*x1 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cheeseburgers: {x0.x}")
    print(f"Bowls of cereal: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
