
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="cheeseburgers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="bowls of cereal", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(9.54 * x1 + 3.68 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x1 + 6 * x2 >= 52)
    model.addConstr(11 * x1 + 7 * x2 >= 20)
    model.addConstr(16 * x1 + 16 * x2 >= 26)
    model.addConstr(7 * x1 + 5 * x2 >= 44)
    model.addConstr(-2 * x1 + 3 * x2 >= 0)
    model.addConstr(2 * x1 + 6 * x2 <= 133)
    model.addConstr(11 * x1 + 7 * x2 <= 28)
    model.addConstr(16 * x1 + 16 * x2 <= 53)
    model.addConstr(7 * x1 + 5 * x2 <= 77)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cheeseburgers: {x1.varValue}")
        print(f"Bowls of cereal: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
